/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.github.f4b6a3.uuid.UuidCreator;
import com.github.f4b6a3.uuid.creator.AbstractTimeBasedUuidCreator;
import com.github.f4b6a3.uuid.creator.rfc4122.TimeBasedUuidCreator;
import com.github.f4b6a3.uuid.strategy.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.util.UuidTime;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.UUID;

public class UUIDWrapper {
    private UUIDWrapper() {
    }

    public static UUID generateRepresentationVersion(Instant date, String recordId) {
        CustomNodeIdentifierStrategy nodeIdentifierStrategy = new CustomNodeIdentifierStrategy(recordId);
        TimeBasedUuidCreator uuidCreator = (TimeBasedUuidCreator)((AbstractTimeBasedUuidCreator)((AbstractTimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withNodeIdentifierStrategy(nodeIdentifierStrategy)).withTimestampStrategy(() -> UuidTime.toTimestamp(date))).withClockSequence(0);
        return uuidCreator.create();
    }

    public static String generateRepresentationFileName(String recordId) {
        return UuidCreator.getNameBasedMd5(recordId).toString();
    }

    private static class CustomNodeIdentifierStrategy
    implements NodeIdentifierStrategy {
        private final String recordId;

        public CustomNodeIdentifierStrategy(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public long getNodeIdentifier() {
            try {
                byte[] md5 = MessageDigest.getInstance("MD5").digest(this.recordId.getBytes());
                return ByteBuffer.wrap(md5).getLong();
            }
            catch (NoSuchAlgorithmException var3) {
                throw new InternalError("MD5 not supported", var3);
            }
        }
    }
}

