/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import eu.europeana.cloud.common.model.dps.TaskByTaskState;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.storm.dao.TasksByStateDAO;
import eu.europeana.cloud.service.dps.storm.utils.TaskStatusUpdater;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TaskStatusSynchronizer {
    private final TaskStatusUpdater taskStatusUpdater;
    private final CassandraTaskInfoDAO taskInfoDAO;
    private final TasksByStateDAO tasksByStateDAO;

    public TaskStatusSynchronizer(CassandraTaskInfoDAO taskInfoDAO, TasksByStateDAO tasksByStateDAO, TaskStatusUpdater taskStatusUpdater) {
        this.taskInfoDAO = taskInfoDAO;
        this.tasksByStateDAO = tasksByStateDAO;
        this.taskStatusUpdater = taskStatusUpdater;
    }

    public void synchronizeTasksByTaskStateFromBasicInfo(String topologyName, Collection<String> availableTopics) {
        List<TaskByTaskState> tasksFromTaskByTaskStateTableList = this.tasksByStateDAO.findTasksByStateAndTopology(Arrays.asList(TaskState.PROCESSING_BY_REST_APPLICATION, TaskState.QUEUED), topologyName);
        Map tasksFromTaskByTaskStateTableMap = tasksFromTaskByTaskStateTableList.stream().filter(info -> availableTopics.contains(info.getTopicName())).collect(Collectors.toMap(TaskByTaskState::getId, Function.identity()));
        List<TaskInfo> tasksFromBasicInfoTable = this.findByIds(tasksFromTaskByTaskStateTableMap.keySet());
        List tasksToCorrect = tasksFromBasicInfoTable.stream().filter(this::isFinished).collect(Collectors.toList());
        for (TaskInfo task : tasksToCorrect) {
            this.taskStatusUpdater.updateTask(topologyName, task.getId(), ((TaskByTaskState)tasksFromTaskByTaskStateTableMap.get(task.getId())).getState(), task.getState());
        }
    }

    private List<TaskInfo> findByIds(Collection<Long> taskIds) {
        return taskIds.stream().map(this.taskInfoDAO::findById).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private boolean isFinished(TaskInfo info) {
        return info.getState() == TaskState.DROPPED || info.getState() == TaskState.PROCESSED;
    }
}

