/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.service.dps.exception.TaskInfoDoesNotExistException;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskInfoDAO;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatusChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStatusChecker.class);
    public static final int CHECKING_INTERVAL_IN_SECONDS = 5;
    public static final int CONCURRENCY_LEVEL = 1000;
    public static final int SIZE = 100;
    private static TaskStatusChecker instance;
    private CassandraTaskInfoDAO taskDAO;
    private static volatile LoadingCache<Long, Boolean> cache;

    private TaskStatusChecker(CassandraConnectionProvider cassandraConnectionProvider) {
        cache = CacheBuilder.newBuilder().refreshAfterWrite(5L, TimeUnit.SECONDS).concurrencyLevel(1000).maximumSize(100L).softValues().build(new CacheLoader<Long, Boolean>(){

            @Override
            public Boolean load(Long taskId) throws ExecutionException, TaskInfoDoesNotExistException {
                return TaskStatusChecker.this.isDroppedTask(taskId);
            }
        });
        this.taskDAO = CassandraTaskInfoDAO.getInstance(cassandraConnectionProvider);
    }

    public TaskStatusChecker(CassandraTaskInfoDAO taskDAO) {
        cache = CacheBuilder.newBuilder().refreshAfterWrite(5L, TimeUnit.SECONDS).concurrencyLevel(1000).maximumSize(100L).softValues().build(new CacheLoader<Long, Boolean>(){

            @Override
            public Boolean load(Long taskId) throws ExecutionException, TaskInfoDoesNotExistException {
                return TaskStatusChecker.this.isDroppedTask(taskId);
            }
        });
        this.taskDAO = taskDAO;
    }

    public static synchronized TaskStatusChecker getTaskStatusChecker() {
        if (instance == null) {
            throw new IllegalStateException("TaskStatusChecker has not been initialized!. Please initialize it first");
        }
        return instance;
    }

    public static synchronized void init(CassandraConnectionProvider cassandraConnectionProvider) {
        if (instance == null) {
            instance = new TaskStatusChecker(cassandraConnectionProvider);
        }
    }

    public boolean hasDroppedStatus(long taskId) {
        try {
            return cache.get(taskId);
        }
        catch (ExecutionException e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }

    private Boolean isDroppedTask(long taskId) throws TaskInfoDoesNotExistException {
        LOGGER.info("Checking the task status for the task id from backend: {}", (Object)taskId);
        return this.taskDAO.isDroppedTask(taskId);
    }
}

