/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import eu.europeana.cloud.common.model.Revision;
import java.util.Date;

public class RevisionIdentifier {
    private String revisionName;
    private String revisionProviderId;
    private Date creationTimeStamp;

    public boolean identifies(Revision revision) {
        return this.revisionName.equals(revision.getRevisionName()) && this.revisionProviderId.equals(revision.getRevisionProviderId()) && (this.creationTimeStamp == null || this.creationTimeStamp.equals(revision.getCreationTimeStamp()));
    }

    public String getRevisionName() {
        return this.revisionName;
    }

    public String getRevisionProviderId() {
        return this.revisionProviderId;
    }

    public Date getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public RevisionIdentifier withRevisionName(String revisionName) {
        return this.revisionName == revisionName ? this : new RevisionIdentifier(revisionName, this.revisionProviderId, this.creationTimeStamp);
    }

    public RevisionIdentifier withRevisionProviderId(String revisionProviderId) {
        return this.revisionProviderId == revisionProviderId ? this : new RevisionIdentifier(this.revisionName, revisionProviderId, this.creationTimeStamp);
    }

    public RevisionIdentifier withCreationTimeStamp(Date creationTimeStamp) {
        return this.creationTimeStamp == creationTimeStamp ? this : new RevisionIdentifier(this.revisionName, this.revisionProviderId, creationTimeStamp);
    }

    public RevisionIdentifier() {
    }

    public RevisionIdentifier(String revisionName, String revisionProviderId, Date creationTimeStamp) {
        this.revisionName = revisionName;
        this.revisionProviderId = revisionProviderId;
        this.creationTimeStamp = creationTimeStamp;
    }

    public String toString() {
        return "RevisionIdentifier(revisionName=" + this.getRevisionName() + ", revisionProviderId=" + this.getRevisionProviderId() + ", creationTimeStamp=" + this.getCreationTimeStamp() + ")";
    }
}

