/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import java.io.Serializable;

public class DbConnectionDetails
implements Serializable {
    private final int port;
    private final String keyspaceName;
    private final String userName;
    private final String password;
    private final String hosts;

    DbConnectionDetails(int port, String keyspaceName, String userName, String password, String hosts) {
        this.port = port;
        this.keyspaceName = keyspaceName;
        this.userName = userName;
        this.password = password;
        this.hosts = hosts;
    }

    public static DbConnectionDetailsBuilder builder() {
        return new DbConnectionDetailsBuilder();
    }

    public int getPort() {
        return this.port;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHosts() {
        return this.hosts;
    }

    public static class DbConnectionDetailsBuilder {
        private int port;
        private String keyspaceName;
        private String userName;
        private String password;
        private String hosts;

        DbConnectionDetailsBuilder() {
        }

        public DbConnectionDetailsBuilder port(int port) {
            this.port = port;
            return this;
        }

        public DbConnectionDetailsBuilder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public DbConnectionDetailsBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public DbConnectionDetailsBuilder password(String password) {
            this.password = password;
            return this;
        }

        public DbConnectionDetailsBuilder hosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public DbConnectionDetails build() {
            return new DbConnectionDetails(this.port, this.keyspaceName, this.userName, this.password, this.hosts);
        }

        public String toString() {
            return "DbConnectionDetails.DbConnectionDetailsBuilder(port=" + this.port + ", keyspaceName=" + this.keyspaceName + ", userName=" + this.userName + ", password=" + this.password + ", hosts=" + this.hosts + ")";
        }
    }
}

