/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.Row;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;

public class BucketRecordIterator<T>
implements Iterator<T> {
    private final int bucketCount;
    private final Function<Row, T> convertMethod;
    private final IntFunction<Iterator<Row>> bucketQueryMethod;
    private int bucketNumber = -1;
    private Iterator<Row> currentBucketIterator;

    public BucketRecordIterator(int bucketCount, IntFunction<Iterator<Row>> bucketQueryMethod, RowConverter<T> convertMethod) {
        this.bucketCount = bucketCount;
        this.bucketQueryMethod = bucketQueryMethod;
        this.convertMethod = convertMethod;
    }

    @Override
    public boolean hasNext() {
        this.goToNextBucketIfNeeded();
        return this.currentBucketIterator.hasNext();
    }

    @Override
    public T next() {
        this.goToNextBucketIfNeeded();
        return this.convertRowToEntity(this.currentBucketIterator.next());
    }

    private void goToNextBucketIfNeeded() {
        while (this.currentBucketIterator == null || !this.currentBucketIterator.hasNext() && this.notLastBucket()) {
            ++this.bucketNumber;
            this.currentBucketIterator = this.queryBucket(this.bucketNumber);
        }
    }

    protected T convertRowToEntity(Row row) {
        return this.convertMethod.apply(row);
    }

    protected Iterator<Row> queryBucket(int bucketNumber) {
        return Objects.requireNonNull(this.bucketQueryMethod.apply(bucketNumber));
    }

    private boolean notLastBucket() {
        return this.bucketNumber < this.bucketCount - 1;
    }

    public static interface RowConverter<R>
    extends Function<Row, R> {
    }
}

