/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.topologies.xslt.bolt;

import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.utils.StormTaskTupleHelper;
import eu.europeana.metis.transformation.service.EuropeanaGeneratedIdsMap;
import eu.europeana.metis.transformation.service.EuropeanaIdCreator;
import eu.europeana.metis.transformation.service.EuropeanaIdException;
import eu.europeana.metis.transformation.service.TransformationException;
import eu.europeana.metis.transformation.service.XsltTransformer;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(XsltBolt.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Tuple anchorTuple, StormTaskTuple stormTaskTuple) {
        StringWriter writer = null;
        try {
            String fileUrl = stormTaskTuple.getFileUrl();
            String xsltUrl = stormTaskTuple.getParameter("XSLT_URL");
            LOGGER.info("Processing file: {} with xslt schema:{}", (Object)fileUrl, (Object)xsltUrl);
            XsltTransformer xsltTransformer = this.prepareXsltTransformer(stormTaskTuple);
            writer = xsltTransformer.transform(stormTaskTuple.getFileData(), this.prepareEuropeanaGeneratedIdsMap(stormTaskTuple));
            LOGGER.info("XsltBolt: transformation success for: {}", (Object)fileUrl);
            stormTaskTuple.setFileData(writer.toString().getBytes(StandardCharsets.UTF_8));
            UrlParser urlParser = new UrlParser(fileUrl);
            if (urlParser.isUrlToRepresentationVersionFile()) {
                stormTaskTuple.addParameter("CLOUD_ID", urlParser.getPart(UrlPart.RECORDS));
                stormTaskTuple.addParameter("REPRESENTATION_NAME", urlParser.getPart(UrlPart.REPRESENTATIONS));
                stormTaskTuple.addParameter("REPRESENTATION_VERSION", urlParser.getPart(UrlPart.VERSIONS));
            }
            this.clearParametersStormTuple(stormTaskTuple);
            this.outputCollector.emit(anchorTuple, (List)stormTaskTuple.toStormTuple());
            this.outputCollector.ack(anchorTuple);
        }
        catch (Exception e) {
            LOGGER.error("XsltBolt error:{}", (Object)e.getMessage());
            this.emitErrorNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), e.getMessage(), ExceptionUtils.getStackTrace(e), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
            this.outputCollector.ack(anchorTuple);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error: during closing the writer {}", (Object)e.getMessage());
                }
            }
        }
    }

    private XsltTransformer prepareXsltTransformer(StormTaskTuple stormTaskTuple) throws TransformationException {
        String xsltUrl = stormTaskTuple.getParameter("XSLT_URL");
        String metisDatasetName = stormTaskTuple.getParameter("METIS_DATASET_NAME");
        String metisDatasetCountry = stormTaskTuple.getParameter("METIS_DATASET_COUNTRY");
        String metisDatasetLanguage = stormTaskTuple.getParameter("METIS_DATASET_LANGUAGE");
        return new XsltTransformer(xsltUrl, metisDatasetName, metisDatasetCountry, metisDatasetLanguage);
    }

    private EuropeanaGeneratedIdsMap prepareEuropeanaGeneratedIdsMap(StormTaskTuple stormTaskTuple) throws EuropeanaIdException {
        String metisDatasetId = stormTaskTuple.getParameter("METIS_DATASET_ID");
        EuropeanaGeneratedIdsMap europeanaGeneratedIdsMap = null;
        if (!StringUtils.isBlank(metisDatasetId)) {
            String fileDataString = new String(stormTaskTuple.getFileData());
            EuropeanaIdCreator europeanIdCreator = new EuropeanaIdCreator();
            europeanaGeneratedIdsMap = europeanIdCreator.constructEuropeanaId(fileDataString, metisDatasetId);
        }
        return europeanaGeneratedIdsMap;
    }

    private void clearParametersStormTuple(StormTaskTuple stormTaskTuple) {
        stormTaskTuple.getParameters().remove("XSLT_URL");
        stormTaskTuple.getParameters().remove("METIS_DATASET_ID");
        stormTaskTuple.getParameters().remove("METIS_DATASET_NAME");
        stormTaskTuple.getParameters().remove("METIS_DATASET_COUNTRY");
        stormTaskTuple.getParameters().remove("METIS_DATASET_LANGUAGE");
    }

    @Override
    public void prepare() {
    }
}

