/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.utils.Clock;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.service.commons.utils.DateHelper;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.utils.StormTaskTupleHelper;
import eu.europeana.cloud.service.dps.storm.utils.TaskTupleUtility;
import eu.europeana.cloud.service.dps.storm.utils.UUIDWrapper;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteRecordBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteRecordBolt.class);
    private final String ecloudMcsAddress;
    protected transient RecordServiceClient recordServiceClient;

    public WriteRecordBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    @Override
    public void prepare() {
        this.recordServiceClient = new RecordServiceClient(this.ecloudMcsAddress);
    }

    @Override
    public void execute(Tuple anchorTuple, StormTaskTuple stormTaskTuple) {
        LOGGER.debug("WriteRecordBolt: persisting processed file");
        Instant processingStartTime = Instant.now();
        try {
            RecordWriteParams writeParams = this.prepareWriteParameters(stormTaskTuple);
            LOGGER.debug("WriteRecordBolt: prepared write parameters: {}", (Object)writeParams);
            URI uri = this.uploadFileInNewRepresentation(stormTaskTuple, writeParams);
            LOGGER.debug("WriteRecordBolt: file modified, new URI: {}", (Object)uri);
            this.prepareEmittedTuple(stormTaskTuple, uri.toString());
            this.outputCollector.emit(anchorTuple, (List)stormTaskTuple.toStormTuple());
        }
        catch (Exception e) {
            LOGGER.warn("Unable to process the message", e);
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            this.emitErrorNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), "Cannot process data because: " + e.getMessage(), stack.toString(), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        }
        this.outputCollector.ack(anchorTuple);
        LOGGER.debug("File persisted in eCloud in: {}ms", (Object)Clock.millisecondsSince(processingStartTime));
    }

    private String getProviderId(StormTaskTuple stormTaskTuple) throws MCSException {
        Representation rep = this.getRepresentation(stormTaskTuple);
        return rep.getDataProvider();
    }

    private Representation getRepresentation(StormTaskTuple stormTaskTuple) throws MCSException {
        return RetryableMethodExecutor.executeOnRest("Error while getting provider id", () -> this.recordServiceClient.getRepresentation(stormTaskTuple.getParameter("CLOUD_ID"), stormTaskTuple.getParameter("REPRESENTATION_NAME"), stormTaskTuple.getParameter("REPRESENTATION_VERSION"), "Authorization", stormTaskTuple.getParameter("AUTHORIZATION_HEADER")));
    }

    private void prepareEmittedTuple(StormTaskTuple stormTaskTuple, String resultedResourceURL) {
        stormTaskTuple.addParameter("OUTPUT_URL", resultedResourceURL);
        stormTaskTuple.setFileData((byte[])null);
        stormTaskTuple.getParameters().remove("CLOUD_ID");
        stormTaskTuple.getParameters().remove("REPRESENTATION_NAME");
        stormTaskTuple.getParameters().remove("REPRESENTATION_VERSION");
    }

    protected RecordWriteParams prepareWriteParameters(StormTaskTuple tuple) throws CloudException, MCSException {
        RecordWriteParams writeParams = new RecordWriteParams();
        writeParams.setCloudId(tuple.getParameter("CLOUD_ID"));
        writeParams.setRepresentationName(TaskTupleUtility.getParameterFromTuple(tuple, "NEW_REPRESENTATION_NAME"));
        writeParams.setProviderId(this.getProviderId(tuple));
        writeParams.setNewVersion(this.generateNewVersionId(tuple));
        writeParams.setNewFileName(this.generateNewFileName(tuple));
        return writeParams;
    }

    protected URI uploadFileInNewRepresentation(StormTaskTuple stormTaskTuple, RecordWriteParams writeParams) throws Exception {
        if (stormTaskTuple.isMarkedAsDeleted()) {
            return this.createRepresentation(stormTaskTuple, writeParams);
        }
        return this.createRepresentationAndUploadFile(stormTaskTuple, writeParams);
    }

    private URI createRepresentation(StormTaskTuple stormTaskTuple, RecordWriteParams writeParams) throws Exception {
        LOGGER.debug("Creating empty representation for tuple that is marked as deleted");
        return RetryableMethodExecutor.executeOnRest("Error while creating representation and uploading file", () -> this.recordServiceClient.createRepresentation(writeParams.getCloudId(), writeParams.getRepresentationName(), writeParams.getProviderId(), writeParams.getNewVersion(), "Authorization", stormTaskTuple.getParameter("AUTHORIZATION_HEADER")));
    }

    protected URI createRepresentationAndUploadFile(StormTaskTuple stormTaskTuple, RecordWriteParams writeParams) throws Exception {
        LOGGER.debug("Creating new representation");
        return RetryableMethodExecutor.executeOnRest("Error while creating representation and uploading file", () -> this.recordServiceClient.createRepresentation(writeParams.getCloudId(), writeParams.getRepresentationName(), writeParams.getProviderId(), writeParams.getNewVersion(), stormTaskTuple.getFileByteDataAsStream(), writeParams.getNewFileName(), TaskTupleUtility.getParameterFromTuple(stormTaskTuple, "OUTPUT_MIME_TYPE"), "Authorization", stormTaskTuple.getParameter("AUTHORIZATION_HEADER")));
    }

    protected UUID generateNewVersionId(StormTaskTuple tuple) {
        return UUIDWrapper.generateRepresentationVersion(DateHelper.parseISODate(tuple.getParameter("SENT_DATE")).toInstant(), tuple.getFileUrl());
    }

    protected String generateNewFileName(StormTaskTuple tuple) {
        String fileFromNameParameter = tuple.getParameter("OUTPUT_FILE_NAME");
        if (fileFromNameParameter != null) {
            return fileFromNameParameter;
        }
        return UUIDWrapper.generateRepresentationFileName(tuple.getFileUrl());
    }

    static class RecordWriteParams {
        String cloudId;
        String representationName;
        String providerId;
        UUID newVersion;
        String newFileName;

        public String getCloudId() {
            return this.cloudId;
        }

        public String getRepresentationName() {
            return this.representationName;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public UUID getNewVersion() {
            return this.newVersion;
        }

        public String getNewFileName() {
            return this.newFileName;
        }

        public void setCloudId(String cloudId) {
            this.cloudId = cloudId;
        }

        public void setRepresentationName(String representationName) {
            this.representationName = representationName;
        }

        public void setProviderId(String providerId) {
            this.providerId = providerId;
        }

        public void setNewVersion(UUID newVersion) {
            this.newVersion = newVersion;
        }

        public void setNewFileName(String newFileName) {
            this.newFileName = newFileName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordWriteParams)) {
                return false;
            }
            RecordWriteParams other = (RecordWriteParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cloudId = this.getCloudId();
            String other$cloudId = other.getCloudId();
            if (this$cloudId == null ? other$cloudId != null : !this$cloudId.equals(other$cloudId)) {
                return false;
            }
            String this$representationName = this.getRepresentationName();
            String other$representationName = other.getRepresentationName();
            if (this$representationName == null ? other$representationName != null : !this$representationName.equals(other$representationName)) {
                return false;
            }
            String this$providerId = this.getProviderId();
            String other$providerId = other.getProviderId();
            if (this$providerId == null ? other$providerId != null : !this$providerId.equals(other$providerId)) {
                return false;
            }
            UUID this$newVersion = this.getNewVersion();
            UUID other$newVersion = other.getNewVersion();
            if (this$newVersion == null ? other$newVersion != null : !((Object)this$newVersion).equals(other$newVersion)) {
                return false;
            }
            String this$newFileName = this.getNewFileName();
            String other$newFileName = other.getNewFileName();
            return !(this$newFileName == null ? other$newFileName != null : !this$newFileName.equals(other$newFileName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RecordWriteParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cloudId = this.getCloudId();
            result = result * 59 + ($cloudId == null ? 43 : $cloudId.hashCode());
            String $representationName = this.getRepresentationName();
            result = result * 59 + ($representationName == null ? 43 : $representationName.hashCode());
            String $providerId = this.getProviderId();
            result = result * 59 + ($providerId == null ? 43 : $providerId.hashCode());
            UUID $newVersion = this.getNewVersion();
            result = result * 59 + ($newVersion == null ? 43 : ((Object)$newVersion).hashCode());
            String $newFileName = this.getNewFileName();
            result = result * 59 + ($newFileName == null ? 43 : $newFileName.hashCode());
            return result;
        }

        public String toString() {
            return "WriteRecordBolt.RecordWriteParams(cloudId=" + this.getCloudId() + ", representationName=" + this.getRepresentationName() + ", providerId=" + this.getProviderId() + ", newVersion=" + this.getNewVersion() + ", newFileName=" + this.getNewFileName() + ")";
        }
    }
}

