/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.io.RevisionWriterBolt;
import eu.europeana.cloud.service.dps.storm.utils.StormTaskTupleHelper;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;
import org.apache.storm.tuple.Tuple;

public class ValidationRevisionWriter
extends RevisionWriterBolt {
    private static final long serialVersionUID = 1L;
    private String successNotificationMessage;

    public ValidationRevisionWriter(String ecloudMcsAddress, String successNotificationMessage) {
        super(ecloudMcsAddress);
        this.successNotificationMessage = successNotificationMessage;
    }

    @Override
    protected void addRevisionAndEmit(Tuple anchorTuple, StormTaskTuple stormTaskTuple) {
        LOGGER.info("{} executed", (Object)((Object)((Object)this)).getClass().getSimpleName());
        try {
            this.addRevisionToSpecificResource(stormTaskTuple, stormTaskTuple.getFileUrl());
            this.emitSuccessNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), this.successNotificationMessage, "", "", StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        }
        catch (MalformedURLException e) {
            LOGGER.error("URL is malformed: {}", (Object)stormTaskTuple.getParameter("CLOUD_LOCAL_IDENTIFIER"));
            this.emitErrorNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), e.getMessage(), "The cause of the error is:" + e.getCause(), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        }
        catch (DriverException | MCSException e) {
            LOGGER.warn("Error while communicating with MCS {}", (Object)e.getMessage());
            this.emitErrorNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), e.getMessage(), "The cause of the error is:" + e.getCause(), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        }
    }
}

