/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.utils.Clock;
import eu.europeana.cloud.mcs.driver.RevisionServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.utils.StormTaskTupleHelper;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionWriterBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    public static final Logger LOGGER = LoggerFactory.getLogger(RevisionWriterBolt.class);
    protected transient RevisionServiceClient revisionsClient;
    private String ecloudMcsAddress;

    public RevisionWriterBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    @Override
    protected boolean ignoreDeleted() {
        return false;
    }

    @Override
    public void execute(Tuple anchorTuple, StormTaskTuple stormTaskTuple) {
        this.addRevisionAndEmit(anchorTuple, stormTaskTuple);
        this.outputCollector.ack(anchorTuple);
    }

    protected void addRevisionAndEmit(Tuple anchorTuple, StormTaskTuple stormTaskTuple) {
        LOGGER.info("Adding revision to the file");
        Instant processingStartTime = Instant.now();
        String resourceURL = this.getResourceUrl(stormTaskTuple);
        try {
            this.addRevisionToSpecificResource(stormTaskTuple, resourceURL);
            this.outputCollector.emit(anchorTuple, (List)stormTaskTuple.toStormTuple());
        }
        catch (MalformedURLException e) {
            LOGGER.error("URL is malformed: {} ", (Object)resourceURL);
            this.emitErrorNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), e.getMessage(), "The cause of the error is:" + e.getCause(), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        }
        catch (DriverException | MCSException e) {
            LOGGER.warn("Error while communicating with MCS {}", (Object)e.getMessage());
            this.emitErrorNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), e.getMessage(), "The cause of the error is:" + e.getCause(), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        }
        LOGGER.info("Revision added in: {}ms", (Object)Clock.millisecondsSince(processingStartTime));
    }

    private String getResourceUrl(StormTaskTuple stormTaskTuple) {
        String resourceURL = stormTaskTuple.getParameter("OUTPUT_URL");
        if (resourceURL == null) {
            resourceURL = stormTaskTuple.getFileUrl();
        }
        return resourceURL;
    }

    protected void addRevisionToSpecificResource(StormTaskTuple stormTaskTuple, String affectedResourceURL) throws MalformedURLException, MCSException {
        if (stormTaskTuple.hasRevisionToBeApplied()) {
            LOGGER.info("The following revision will be added: {}", (Object)stormTaskTuple.getRevisionToBeApplied());
            UrlParser urlParser = new UrlParser(affectedResourceURL);
            Revision revisionToBeApplied = stormTaskTuple.getRevisionToBeApplied();
            if (revisionToBeApplied.getCreationTimeStamp() == null) {
                revisionToBeApplied.setCreationTimeStamp(new Date());
            }
            if (stormTaskTuple.isMarkedAsDeleted()) {
                revisionToBeApplied = new Revision(revisionToBeApplied);
                revisionToBeApplied.setDeleted(true);
            }
            this.addRevision(urlParser, revisionToBeApplied, stormTaskTuple.getParameter("AUTHORIZATION_HEADER"));
        } else {
            LOGGER.info("Revisions list is empty");
        }
    }

    private void addRevision(UrlParser urlParser, Revision revisionToBeApplied, String authenticationHeader) throws MCSException {
        RetryableMethodExecutor.executeOnRest("Error while adding Revisions", () -> this.revisionsClient.addRevision(urlParser.getPart(UrlPart.RECORDS), urlParser.getPart(UrlPart.REPRESENTATIONS), urlParser.getPart(UrlPart.VERSIONS), revisionToBeApplied, "Authorization", authenticationHeader));
    }

    @Override
    public void prepare() {
        if (this.ecloudMcsAddress == null) {
            throw new NullPointerException("MCS Server must be set!");
        }
        this.revisionsClient = new RevisionServiceClient(this.ecloudMcsAddress);
    }

    @Override
    protected void cleanInvalidData(StormTaskTuple tuple) {
        int attemptNumber = tuple.getRecordAttemptNumber();
        LOGGER.info("Attempt number {} to process this message. No cleaning needed here.", (Object)attemptNumber);
    }
}

