/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.common.utils.Clock;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.utils.StormTaskTupleHelper;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFileBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadFileBolt.class);
    private final String ecloudMcsAddress;
    protected transient FileServiceClient fileClient;

    public ReadFileBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    @Override
    public void prepare() {
        this.fileClient = new FileServiceClient(this.ecloudMcsAddress);
    }

    @Override
    public void execute(Tuple anchorTuple, StormTaskTuple t) {
        String file = t.getParameters().get("CLOUD_LOCAL_IDENTIFIER");
        try (InputStream is = this.getFileStreamByStormTuple(t);){
            t.setFileData(is);
            this.outputCollector.emit(anchorTuple, (List)t.toStormTuple());
        }
        catch (FileNotExistsException | RepresentationNotExistsException | WrongContentRangeException ex) {
            LOGGER.warn("Can not retrieve file at {}", (Object)file);
            this.emitErrorNotification(anchorTuple, t.getTaskId(), t.isMarkedAsDeleted(), file, "Can not retrieve file", "The cause of the error is:" + ex.getCause(), StormTaskTupleHelper.getRecordProcessingStartTime(t));
        }
        catch (Exception ex) {
            LOGGER.error("ReadFileBolt error: {}", (Object)ex.getMessage());
            this.emitErrorNotification(anchorTuple, t.getTaskId(), t.isMarkedAsDeleted(), file, ex.getMessage(), "The cause of the error is:" + ex.getCause(), StormTaskTupleHelper.getRecordProcessingStartTime(t));
        }
        this.outputCollector.ack(anchorTuple);
    }

    private InputStream getFile(FileServiceClient fileClient, String file, String authorization) throws Exception {
        return RetryableMethodExecutor.executeOnRest("Error while getting a file", () -> fileClient.getFile(file, "Authorization", authorization));
    }

    protected InputStream getFileStreamByStormTuple(StormTaskTuple stormTaskTuple) throws Exception {
        Instant processingStartTime = Instant.now();
        String file = stormTaskTuple.getParameters().get("CLOUD_LOCAL_IDENTIFIER");
        LOGGER.info("Downloading the following file: {}", (Object)file);
        stormTaskTuple.setFileUrl(file);
        InputStream downloadedFile = this.getFile(this.fileClient, file, stormTaskTuple.getParameter("AUTHORIZATION_HEADER"));
        LOGGER.info("File downloaded in {}ms", (Object)Clock.millisecondsSince(processingStartTime));
        return downloadedFile;
    }
}

