/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.PluginParameterKeys;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.io.WriteRecordBolt;
import eu.europeana.cloud.service.uis.exception.IdHasBeenMappedException;
import eu.europeana.cloud.service.uis.exception.RecordDoesNotExistException;

public class HarvestingWriteRecordBolt
extends WriteRecordBolt {
    public static final String ERROR_MSG_WHILE_CREATING_CLOUD_ID = "Error while creating CloudId";
    public static final String ERROR_MSG_WHILE_MAPPING_LOCAL_CLOUD_ID = "Error while mapping localId to cloudId";
    public static final String ERROR_MSG_WHILE_GETTING_CLOUD_ID = "Error while getting CloudId";
    private static final long serialVersionUID = 1L;
    private String ecloudUisAddress;
    private transient UISClient uisClient;

    public HarvestingWriteRecordBolt(String ecloudMcsAddress, String ecloudUisAddress) {
        super(ecloudMcsAddress);
        this.ecloudUisAddress = ecloudUisAddress;
    }

    @Override
    protected boolean ignoreDeleted() {
        return false;
    }

    @Override
    public void prepare() {
        this.uisClient = new UISClient(this.ecloudUisAddress);
        super.prepare();
    }

    private String getCloudId(String authorizationHeader, String providerId, String localId, String additionalLocalIdentifier) throws CloudException {
        CloudId cloudId = this.getCloudId(providerId, localId, authorizationHeader);
        String result = cloudId != null ? cloudId.getId() : this.createCloudId(providerId, localId, authorizationHeader);
        if (additionalLocalIdentifier != null) {
            this.attachAdditionalLocalIdentifier(additionalLocalIdentifier, result, providerId, authorizationHeader);
        }
        return result;
    }

    private boolean attachAdditionalLocalIdentifier(String additionalLocalIdentifier, String cloudId, String providerId, String authorizationHeader) throws CloudException {
        return RetryableMethodExecutor.executeOnRest(ERROR_MSG_WHILE_MAPPING_LOCAL_CLOUD_ID, () -> {
            try {
                return this.uisClient.createMapping(cloudId, providerId, additionalLocalIdentifier, "Authorization", authorizationHeader);
            }
            catch (Exception e) {
                if (e.getCause() instanceof IdHasBeenMappedException) {
                    return true;
                }
                throw e;
            }
        });
    }

    private CloudId getCloudId(String providerId, String localId, String authenticationHeader) throws CloudException {
        return RetryableMethodExecutor.executeOnRest(ERROR_MSG_WHILE_GETTING_CLOUD_ID, () -> {
            try {
                return this.uisClient.getCloudId(providerId, localId, "Authorization", authenticationHeader);
            }
            catch (Exception e) {
                if (e.getCause() instanceof RecordDoesNotExistException) {
                    return null;
                }
                throw e;
            }
        });
    }

    private String createCloudId(String providerId, String localId, String authenticationHeader) throws CloudException {
        return RetryableMethodExecutor.executeOnRest(ERROR_MSG_WHILE_CREATING_CLOUD_ID, () -> this.uisClient.createCloudId(providerId, localId, "Authorization", authenticationHeader).getId());
    }

    @Override
    protected WriteRecordBolt.RecordWriteParams prepareWriteParameters(StormTaskTuple stormTaskTuple) throws CloudException {
        String providerId = stormTaskTuple.getParameter("PROVIDER_ID");
        String localId = stormTaskTuple.getParameter("CLOUD_LOCAL_IDENTIFIER");
        String additionalLocalIdentifier = stormTaskTuple.getParameter("ADDITIONAL_LOCAL_IDENTIFIER");
        String authenticationHeader = stormTaskTuple.getParameter("AUTHORIZATION_HEADER");
        String cloudId = this.getCloudId(authenticationHeader, providerId, localId, additionalLocalIdentifier);
        String representationName = stormTaskTuple.getParameter("NEW_REPRESENTATION_NAME");
        if ((representationName == null || representationName.isEmpty()) && stormTaskTuple.getSourceDetails() != null && (representationName = stormTaskTuple.getParameter("SCHEMA_NAME")) == null) {
            representationName = PluginParameterKeys.PLUGIN_PARAMETERS.get("NEW_REPRESENTATION_NAME");
        }
        WriteRecordBolt.RecordWriteParams writeParams = new WriteRecordBolt.RecordWriteParams();
        writeParams.setCloudId(cloudId);
        writeParams.setRepresentationName(representationName);
        writeParams.setProviderId(providerId);
        writeParams.setNewVersion(this.generateNewVersionId(stormTaskTuple));
        writeParams.setNewFileName(this.generateNewFileName(stormTaskTuple));
        return writeParams;
    }
}

