/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.utils.Clock;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.commons.urls.DataSetUrlParser;
import eu.europeana.cloud.service.commons.urls.RepresentationParser;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.utils.StormTaskTupleHelper;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;
import java.time.Instant;
import java.util.List;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddResultToDataSetBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AddResultToDataSetBolt.class);
    private final String ecloudMcsAddress;
    private transient DataSetServiceClient dataSetServiceClient;

    public AddResultToDataSetBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    @Override
    protected boolean ignoreDeleted() {
        return false;
    }

    protected boolean shouldAddDeletedRecordToDataset() {
        return false;
    }

    @Override
    public void prepare() {
        if (this.ecloudMcsAddress == null) {
            throw new NullPointerException("MCS Server must be set!");
        }
        this.dataSetServiceClient = new DataSetServiceClient(this.ecloudMcsAddress);
    }

    @Override
    public void execute(Tuple anchorTuple, StormTaskTuple stormTaskTuple) {
        LOGGER.info("Adding representation versions to dataset");
        Instant processingStartTime = Instant.now();
        String authorizationHeader = stormTaskTuple.getParameter("AUTHORIZATION_HEADER");
        String resultUrl = stormTaskTuple.getParameter("OUTPUT_URL");
        try {
            if (!stormTaskTuple.isMarkedAsDeleted() || this.shouldAddDeletedRecordToDataset()) {
                this.addRecordToDataset(stormTaskTuple, authorizationHeader, resultUrl);
            }
            if (stormTaskTuple.getParameter("UNIFIED_ERROR_MESSAGE") == null) {
                this.emitSuccessNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), "", "", resultUrl, StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
            } else {
                this.emitSuccessNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), "", "", resultUrl, stormTaskTuple.getParameter("UNIFIED_ERROR_MESSAGE"), stormTaskTuple.getParameter("EXCEPTION_ERROR_MESSAGE"), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
            }
        }
        catch (DriverException | MCSException e) {
            LOGGER.warn("Error while communicating with MCS {}", (Object)e.getMessage());
            this.emitErrorNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), e.getMessage(), "The cause of the error is: " + e.getCause(), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        }
        catch (MalformedURLException e) {
            this.emitErrorNotification(anchorTuple, stormTaskTuple.getTaskId(), stormTaskTuple.isMarkedAsDeleted(), stormTaskTuple.getFileUrl(), e.getMessage(), "The cause of the error is: " + e.getCause(), StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        }
        this.outputCollector.ack(anchorTuple);
        LOGGER.info("Representation version added to dataset in: {}ms", (Object)Clock.millisecondsSince(processingStartTime));
    }

    private void addRecordToDataset(StormTaskTuple stormTaskTuple, String authorizationHeader, String resultUrl) throws MalformedURLException, MCSException {
        List<DataSet> datasets = DataSetUrlParser.parseList(stormTaskTuple.getParameter("OUTPUT_DATA_SETS"));
        LOGGER.info("Data-sets that will be affected: {}", (Object)datasets);
        for (DataSet dataSet : datasets) {
            Representation resultRepresentation = RepresentationParser.parseResultUrl(resultUrl);
            this.assignRepresentationToDataSet(dataSet, resultRepresentation, authorizationHeader);
        }
    }

    private void assignRepresentationToDataSet(DataSet dataSet, Representation resultRepresentation, String authorizationHeader) throws MCSException {
        RetryableMethodExecutor.executeOnRest("Error while assigning record to dataset", () -> this.dataSetServiceClient.assignRepresentationToDataSet(dataSet.getProviderId(), dataSet.getId(), resultRepresentation.getCloudId(), resultRepresentation.getRepresentationName(), resultRepresentation.getVersion(), "Authorization", authorizationHeader));
    }
}

