/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.NodeStatistics;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.List;
import java.util.stream.Collectors;

@Retryable(maxAttempts=7)
public class CassandraNodeStatisticsDAO
extends CassandraDAO {
    private PreparedStatement updateNodeStatement;
    private PreparedStatement searchNodesStatement;
    private PreparedStatement searchNodesStatementAll;
    private PreparedStatement deleteNodesStatisticsStatement;
    private static CassandraNodeStatisticsDAO instance = null;

    public static synchronized CassandraNodeStatisticsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = RetryableMethodExecutor.createRetryProxy(new CassandraNodeStatisticsDAO(cassandra));
        }
        return instance;
    }

    public CassandraNodeStatisticsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public CassandraNodeStatisticsDAO() {
    }

    @Override
    protected void prepareStatements() {
        this.updateNodeStatement = this.dbService.getSession().prepare("UPDATE node_statistics SET occurrence = occurrence + ? WHERE task_id = ? AND node_xpath = ? AND node_value = ?");
        this.updateNodeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchNodesStatement = this.dbService.getSession().prepare("SELECT * FROM node_statistics WHERE task_id = ? AND node_xpath = ? limit ?");
        this.searchNodesStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchNodesStatementAll = this.dbService.getSession().prepare("SELECT * FROM node_statistics WHERE task_id = ? AND node_xpath = ?");
        this.searchNodesStatementAll.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.deleteNodesStatisticsStatement = this.dbService.getSession().prepare("DELETE  FROM node_statistics WHERE task_id = ? AND node_xpath = ?");
        this.deleteNodesStatisticsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public void updateNodeStatistics(long taskId, NodeStatistics nodeStatistics) {
        this.dbService.getSession().execute(this.updateNodeStatement.bind(nodeStatistics.getOccurrence(), taskId, nodeStatistics.getXpath(), nodeStatistics.getValue()));
    }

    public List<String> searchNodeStatisticsValues(long taskId, String nodeXpath) {
        return this.dbService.getSession().execute(this.searchNodesStatementAll.bind(taskId, nodeXpath)).all().stream().map(row -> row.getString("node_value")).collect(Collectors.toList());
    }

    public void removeNodeStatistics(long taskId, String nodeXpath) {
        this.dbService.getSession().execute(this.deleteNodesStatisticsStatement.bind(taskId, nodeXpath));
    }

    public List<NodeStatistics> getNodeStatistics(long taskId, String parentXpath, String nodeXpath, int limit) {
        return this.dbService.getSession().execute(this.searchNodesStatement.bind(taskId, nodeXpath, limit)).all().stream().map(row -> this.createNodeStatistics(parentXpath, nodeXpath, (Row)row)).collect(Collectors.toList());
    }

    private NodeStatistics createNodeStatistics(String parentXpath, String nodeXpath, Row row) {
        return new NodeStatistics(parentXpath, nodeXpath, row.getString("node_value"), row.getLong("occurrence"));
    }
}

