/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.PreparedStatement;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;

public abstract class CassandraDAO {
    protected String hostList;
    protected String keyspaceName;
    protected String port;
    protected CassandraConnectionProvider dbService;

    protected abstract void prepareStatements();

    protected CassandraDAO() {
    }

    public CassandraDAO(CassandraConnectionProvider dbService) {
        this.keyspaceName = dbService.getKeyspaceName();
        this.dbService = dbService;
        this.port = dbService.getPort();
        this.hostList = dbService.getHosts();
        this.prepareStatements();
    }

    public String getHostList() {
        return this.hostList;
    }

    public String getKeyspace() {
        return this.keyspaceName;
    }

    public String getPort() {
        return this.port;
    }

    protected PreparedStatement prepare(String query2) {
        PreparedStatement statement = this.dbService.getSession().prepare(query2);
        statement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        return statement;
    }
}

