/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.service.dps.OAIPMHHarvestingDetails;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class StormTaskTuple
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BATCH_MAX_SIZE = 4096;
    private String fileUrl;
    private byte[] fileData;
    private long taskId;
    private String taskName;
    private Map<String, String> parameters;
    private Revision revisionToBeApplied;
    private OAIPMHHarvestingDetails sourceDetails;
    private int recordAttemptNumber;

    public StormTaskTuple() {
        this(0L, "", null, null, new HashMap<String, String>(), null);
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revisionToBeApplied) {
        this(taskId, taskName, fileUrl, fileData, parameters, revisionToBeApplied, null);
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revisionToBeApplied, OAIPMHHarvestingDetails sourceDetails) {
        this(taskId, taskName, fileUrl, fileData, parameters, revisionToBeApplied, sourceDetails, 0);
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revisionToBeApplied, OAIPMHHarvestingDetails sourceDetails, int recordAttemptNumber) {
        this.taskId = taskId;
        this.taskName = taskName;
        this.fileUrl = fileUrl;
        this.fileData = fileData;
        this.parameters = parameters;
        this.revisionToBeApplied = revisionToBeApplied;
        this.sourceDetails = sourceDetails;
        this.recordAttemptNumber = recordAttemptNumber;
    }

    public ByteArrayInputStream getFileByteDataAsStream() {
        if (this.fileData != null) {
            return new ByteArrayInputStream(this.fileData);
        }
        return null;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileData(InputStream is) throws IOException {
        try (ByteArrayOutputStream tempByteArrayOutputStream = new ByteArrayOutputStream();){
            if (is != null) {
                byte[] buffer = new byte[4096];
                IOUtils.copyLarge(is, tempByteArrayOutputStream, buffer);
                this.fileData = tempByteArrayOutputStream.toByteArray();
            } else {
                this.fileData = null;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void addParameter(String parameterKey, String parameterValue) {
        this.parameters.put(parameterKey, parameterValue);
    }

    public String getParameter(String parameterKey) {
        return this.parameters.get(parameterKey);
    }

    public boolean hasRevisionToBeApplied() {
        return this.revisionToBeApplied != null;
    }

    public static StormTaskTuple fromStormTuple(Tuple tuple) {
        return new StormTaskTuple(tuple.getLongByField("TASK_ID"), tuple.getStringByField("TASK_NAME"), tuple.getStringByField("INPUT_FILES"), tuple.getBinaryByField("FILE_CONTENT"), (HashMap)tuple.getValueByField("PARAMETERS"), (Revision)tuple.getValueByField("REVISIONS"), (OAIPMHHarvestingDetails)tuple.getValueByField("SOURCE"), tuple.getIntegerByField("RECORD_ATTEMPT_NUMBER"));
    }

    public static StormTaskTuple fromValues(List<Object> list) {
        return new StormTaskTuple((Long)list.get(0), (String)list.get(1), (String)list.get(2), (byte[])list.get(3), (Map)list.get(4), (Revision)list.get(5), (OAIPMHHarvestingDetails)list.get(6), (Integer)list.get(7));
    }

    public Values toStormTuple() {
        return new Values(new Object[]{this.taskId, this.taskName, this.fileUrl, this.fileData, this.parameters, this.revisionToBeApplied, this.sourceDetails, this.recordAttemptNumber});
    }

    public static Fields getFields() {
        return new Fields(new String[]{"TASK_ID", "TASK_NAME", "INPUT_FILES", "FILE_CONTENT", "PARAMETERS", "REVISIONS", "SOURCE", "RECORD_ATTEMPT_NUMBER"});
    }

    public boolean isMarkedAsDeleted() {
        return "true".equals(this.parameters.get("DELETED_RECORD"));
    }

    public void setMarkedAsDeleted(boolean markedAsDeleted) {
        if (markedAsDeleted) {
            this.parameters.put("DELETED_RECORD", "true");
        } else {
            this.parameters.remove("DELETED_RECORD");
        }
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setRevisionToBeApplied(Revision revisionToBeApplied) {
        this.revisionToBeApplied = revisionToBeApplied;
    }

    public void setSourceDetails(OAIPMHHarvestingDetails sourceDetails) {
        this.sourceDetails = sourceDetails;
    }

    public void setRecordAttemptNumber(int recordAttemptNumber) {
        this.recordAttemptNumber = recordAttemptNumber;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Revision getRevisionToBeApplied() {
        return this.revisionToBeApplied;
    }

    public OAIPMHHarvestingDetails getSourceDetails() {
        return this.sourceDetails;
    }

    public int getRecordAttemptNumber() {
        return this.recordAttemptNumber;
    }
}

