/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm;

import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.service.dps.metis.indexing.DataSetCleanerParameters;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class NotificationTuple {
    public static final String TASK_ID_FIELD_NAME = "TASK_ID";
    public static final String PARAMETERS_FIELD_NAME = "PARAMETERS";
    private final long taskId;
    private final Map<String, Object> parameters;

    public NotificationTuple(long taskId, Map<String, Object> parameters) {
        this.taskId = taskId;
        this.parameters = parameters;
    }

    public static NotificationTuple prepareNotification(long taskId, boolean markedAsDeleted, String resource, RecordState state, String text, String additionalInformations, long processingStartTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource", resource);
        parameters.put("state", state.toString());
        parameters.put("info_text", text);
        parameters.put("additionalInfo", additionalInformations);
        parameters.put("START_TIME", processingStartTime);
        if (markedAsDeleted) {
            parameters.put("DELETED_RECORD", "true");
        }
        return new NotificationTuple(taskId, parameters);
    }

    public static NotificationTuple prepareNotification(long taskId, boolean markedAsDeleted, String resource, RecordState state, String text, String additionalInformations, String resultResource, long processingStartTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource", resource);
        parameters.put("state", state.toString());
        parameters.put("info_text", text);
        parameters.put("additionalInfo", additionalInformations);
        parameters.put("resultResource", resultResource);
        parameters.put("START_TIME", processingStartTime);
        if (markedAsDeleted) {
            parameters.put("DELETED_RECORD", "true");
        }
        return new NotificationTuple(taskId, parameters);
    }

    public static NotificationTuple prepareIndexingNotification(long taskId, boolean markedAsDeleted, DataSetCleanerParameters dataSetCleanerParameters, String authenticationHeader, String resource, RecordState state, String text, String additionalInformations, String resultResource, long processingStartTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource", resource);
        parameters.put("state", state.toString());
        parameters.put("info_text", text);
        parameters.put("additionalInfo", additionalInformations);
        parameters.put("resultResource", resultResource);
        parameters.put("DATA_SET_CLEANING_PARAMETERS", dataSetCleanerParameters);
        parameters.put("AUTHORIZATION_HEADER", authenticationHeader);
        parameters.put("START_TIME", processingStartTime);
        if (markedAsDeleted) {
            parameters.put("DELETED_RECORD", "true");
        }
        return new NotificationTuple(taskId, parameters);
    }

    public long getTaskId() {
        return this.taskId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public static NotificationTuple fromStormTuple(Tuple tuple) {
        return new NotificationTuple(tuple.getLongByField(TASK_ID_FIELD_NAME), (Map)tuple.getValueByField(PARAMETERS_FIELD_NAME));
    }

    public Values toStormTuple() {
        return new Values(new Object[]{this.taskId, this.parameters});
    }

    public static Fields getFields() {
        return new Fields(new String[]{TASK_ID_FIELD_NAME, PARAMETERS_FIELD_NAME});
    }

    public boolean isMarkedAsDeleted() {
        return "true".equals(this.parameters.get("DELETED_RECORD"));
    }

    public boolean isIgnoredRecord() {
        return "true".equals(this.parameters.get("IGNORED_RECORD"));
    }
}

