/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.exception;

import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrTopologyDoesNotExistException;
import eu.europeana.cloud.service.dps.exception.DPSClientException;
import eu.europeana.cloud.service.dps.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.dps.exception.DpsException;
import eu.europeana.cloud.service.dps.exception.DpsTaskValidationException;
import eu.europeana.cloud.service.dps.exception.TaskInfoDoesNotExistException;
import eu.europeana.cloud.service.dps.exception.TopologyAlreadyExistsException;
import eu.europeana.cloud.service.dps.status.DpsErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPSExceptionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DPSExceptionProvider.class);

    private DPSExceptionProvider() {
    }

    public static DpsException createException(ErrorInfo errorInfo) {
        DpsErrorCode dpsErrorCode;
        LOGGER.error("errorInfo = {}", (Object)errorInfo);
        if (errorInfo == null) {
            throw new DPSClientException("Null errorInfo passed to generating exception.");
        }
        try {
            dpsErrorCode = DpsErrorCode.valueOf(errorInfo.getErrorCode());
        }
        catch (IllegalArgumentException e) {
            throw new DPSClientException("Unknown errorCode returned from service.", e);
        }
        String details = errorInfo.getDetails();
        switch (dpsErrorCode) {
            case ACCESS_DENIED_OR_OBJECT_DOES_NOT_EXIST_EXCEPTION: {
                return new AccessDeniedOrObjectDoesNotExistException(details);
            }
            case ACCESS_DENIED_OR_TOPOLOGY_DOES_NOT_EXIST_EXCEPTION: {
                return new AccessDeniedOrTopologyDoesNotExistException(details);
            }
            case TOPOLOGY_ALREADY_EXIST: {
                return new TopologyAlreadyExistsException(details);
            }
            case TASK_NOT_VALID: {
                return new DpsTaskValidationException(details);
            }
            case DATABASE_CONNECTION_EXCEPTION: {
                return new DatabaseConnectionException(details);
            }
            case TASKINFO_DOES_NOT_EXIST_EXCEPTION: {
                return new TaskInfoDoesNotExistException(details);
            }
            case OTHER: {
                throw new DPSClientException(details);
            }
        }
        return new DpsException(details);
    }

    public static DpsException createException(String generalMessage, String particularMessage, Throwable cause) {
        String message = String.format("%s (%s)", generalMessage, particularMessage);
        LOGGER.error(message, cause);
        return new DpsException(message, cause);
    }
}

