/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.urls;

import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSetUrlParser {
    private DataSetUrlParser() {
    }

    public static DataSet parse(String url) throws MalformedURLException {
        UrlParser parser = new UrlParser(url);
        if (parser.isUrlToDataset()) {
            DataSet dataSet = new DataSet();
            dataSet.setId(parser.getPart(UrlPart.DATA_SETS));
            dataSet.setProviderId(parser.getPart(UrlPart.DATA_PROVIDERS));
            return dataSet;
        }
        throw new MalformedURLException("The dataSet URL is not formulated correctly");
    }

    public static List<DataSet> parseList(String urlList) throws MalformedURLException {
        if (urlList == null) {
            return Collections.emptyList();
        }
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        for (String url : urlList.split(",")) {
            result.add(DataSetUrlParser.parse(url));
        }
        return result;
    }
}

