/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.md5;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Pattern;

public class FileMd5GenerationService {
    private static final String HEX_NUMBER_REGEXP = "[0-9a-fA-F]*";
    private static final Pattern HEX_NUMBER_PATTER = Pattern.compile("[0-9a-fA-F]*");

    private FileMd5GenerationService() {
    }

    public static byte[] generate(Path filePath) throws IOException {
        return FileMd5GenerationService.generate(Files.readAllBytes(filePath));
    }

    public static byte[] generate(byte[] fileBytes) {
        try {
            return MessageDigest.getInstance("MD5").digest(fileBytes);
        }
        catch (NoSuchAlgorithmException var3) {
            throw new InternalError("MD5 not supported", var3);
        }
    }

    public static UUID generateUUID(Path filePath) throws IOException {
        return FileMd5GenerationService.generateUUID(Files.readAllBytes(filePath));
    }

    public static UUID generateUUID(byte[] fileBytes) {
        return UUID.nameUUIDFromBytes(fileBytes);
    }

    public static UUID md5ToUUID(byte[] md5digest) {
        int i;
        if (md5digest == null) {
            throw new NullPointerException("md5digest cannot be null");
        }
        if (md5digest.length != 16) {
            throw new IllegalArgumentException("md5digest has to have 16 bytes");
        }
        byte[] md5Bytes = Arrays.copyOf(md5digest, md5digest.length);
        md5Bytes[6] = (byte)(md5Bytes[6] & 0xF);
        md5Bytes[6] = (byte)(md5Bytes[6] | 0x30);
        md5Bytes[8] = (byte)(md5Bytes[8] & 0x3F);
        md5Bytes[8] = (byte)(md5Bytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(md5Bytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(md5Bytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static UUID md5ToUUID(String md5digestInHex) {
        if (md5digestInHex == null) {
            throw new NullPointerException("md5digestInHex cannot be null");
        }
        if (md5digestInHex.length() != 32) {
            throw new IllegalArgumentException("md5digestInHex has to have 16 bytes");
        }
        if (!HEX_NUMBER_PATTER.matcher(md5digestInHex).matches()) {
            throw new IllegalArgumentException("md5digestInHex is not a valid hexadecimal number");
        }
        byte[] md5digest = new byte[16];
        for (int index = 0; index < 16; ++index) {
            md5digest[index] = (byte)Integer.parseInt(md5digestInHex.substring(2 * index, 2 * index + 2), 16);
        }
        return FileMd5GenerationService.md5ToUUID(md5digest);
    }
}

