/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.utils.Tags;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.service.commons.utils.DateHelper;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class RevisionServiceClient
extends MCSClient {
    public RevisionServiceClient(String baseUrl) {
        this(baseUrl, 20000, 60000);
    }

    public RevisionServiceClient(String baseUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public RevisionServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, username, password, 20000, 60000);
    }

    public RevisionServiceClient(String baseUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        this.client.register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public URI addRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, String tag) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions/{revisionName}/revisionProvider/{revisionProviderId}/tag/{tag}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId).resolveTemplate("tag", tag).request().post(null));
    }

    public URI addRevision(String cloudId, String representationName, String version, Revision revision) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().accept("application/json").post(Entity.json(revision)));
    }

    public URI addRevision(String cloudId, String representationName, String version, Revision revision, String key, String value) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().header(key, value).accept("application/json").post(Entity.json(revision)));
    }

    public URI addRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, Set<Tags> tags) throws MCSException {
        Form form = new Form();
        for (Tags tag : tags) {
            form.param("tags", tag.getTag());
        }
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions/{revisionName}/revisionProvider/{revisionProviderId}/tags").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId).request().post(Entity.form(form)));
    }

    public void deleteRevision(String cloudId, String representationName, String version, Revision revision) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("revisionName", revision.getRevisionName()).resolveTemplate("revisionProviderId", revision.getRevisionProviderId()).queryParam("revisionTimestamp", DateHelper.getISODateString(revision.getCreationTimeStamp())).request().delete());
    }

    public void deleteRevision(String cloudId, String representationName, String version, Revision revision, String key, String value) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("revisionName", revision.getRevisionName()).resolveTemplate("revisionProviderId", revision.getRevisionProviderId()).queryParam("revisionTimestamp", DateHelper.getISODateString(revision.getCreationTimeStamp())).request().header(key, value).delete());
    }
}

