/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.Permission;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.service.commons.utils.DateHelper;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class RecordServiceClient
extends MCSClient {
    public RecordServiceClient(String baseUrl) {
        this(baseUrl, 20000, 60000);
    }

    public RecordServiceClient(String baseUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this(baseUrl, null, null, null, connectTimeoutInMillis, readTimeoutInMillis);
    }

    public RecordServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, null, username, password, 20000, 60000);
    }

    public RecordServiceClient(String baseUrl, String authorizationHeader) {
        this(baseUrl, authorizationHeader, null, null, 20000, 60000);
    }

    public RecordServiceClient(String baseUrl, String authorizationHeader, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        if (authorizationHeader != null) {
            this.client.register(new ECloudBasicAuthFilter(authorizationHeader));
        } else if (username != null || password != null) {
            this.client.register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        }
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public Record getRecord(String cloudId) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<Record>(Record.class), () -> this.client.target(this.baseUrl).path("/records/{cloudId}").resolveTemplate("cloudId", cloudId).request().get());
    }

    public void deleteRecord(String cloudId) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}").resolveTemplate("cloudId", cloudId).request().delete());
    }

    public List<Representation> getRepresentations(String cloudId) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<List<Representation>>(new GenericType<List<Representation>>(){}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations").resolveTemplate("cloudId", cloudId).request().get());
    }

    public Representation getRepresentation(String cloudId, String representationName) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<Representation>(Representation.class, new Response.Status[]{Response.Status.OK, Response.Status.TEMPORARY_REDIRECT}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().get());
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, String key, String value) throws MCSException {
        return this.createRepresentation(cloudId, representationName, providerId, (UUID)null, key, value);
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, UUID version, String key, String value) throws MCSException {
        Form form = new Form();
        form.param("providerId", providerId);
        if (version != null) {
            form.param("version", version.toString());
        }
        if (key == null) {
            return this.createRepresentation(cloudId, representationName, form);
        }
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().header(key, value).post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    private URI createRepresentation(String cloudId, String representationName, Form form) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId) throws MCSException {
        return this.createRepresentation(cloudId, representationName, providerId, (String)null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI createRepresentation(String cloudId, String representationName, String providerId, InputStream data, String fileName, String mediaType) throws IOException, MCSException {
        FormDataMultiPart multiPart = this.prepareRequestBody(providerId, data, fileName, mediaType);
        try {
            URI uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().header("Content-Type", "multipart/form-data").post(Entity.entity(multiPart, "multipart/form-data")));
            return uRI;
        }
        finally {
            this.closeDataSources(data, multiPart);
        }
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, InputStream data, String fileName, String mediaType, String key, String value) throws IOException, MCSException {
        return this.createRepresentation(cloudId, representationName, providerId, null, data, fileName, mediaType, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI createRepresentation(String cloudId, String representationName, String providerId, UUID version, InputStream data, String fileName, String mediaType, String key, String value) throws IOException, MCSException {
        FormDataMultiPart multiPart = this.prepareRequestBody(providerId, data, fileName, mediaType);
        if (version != null) {
            multiPart.field("version", version.toString());
        }
        try {
            URI uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().header(key, value).post(Entity.entity(multiPart, "multipart/form-data")));
            return uRI;
        }
        finally {
            this.closeDataSources(data, multiPart);
        }
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, InputStream data, String mediaType) throws IOException, MCSException {
        return this.createRepresentation(cloudId, representationName, providerId, data, null, mediaType);
    }

    public void deleteRepresentation(String cloudId, String representationName) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().delete());
    }

    public List<Representation> getRepresentations(String cloudId, String representationName) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<List<Representation>>(new GenericType<List<Representation>>(){}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().get());
    }

    public Representation getRepresentation(String cloudId, String representationName, String version) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<Representation>(Representation.class), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().get());
    }

    public Representation getRepresentation(String cloudId, String representationName, String version, String key, String value) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<Representation>(Representation.class), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().header(key, value).get());
    }

    public void deleteRepresentation(String cloudId, String representationName, String version) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().delete());
    }

    public void deleteRepresentation(String cloudId, String representationName, String version, String key, String value) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().header(key, value).delete());
    }

    public URI copyRepresentation(String cloudId, String representationName, String version) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/copy").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().post(Entity.entity(new Form(), MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    public URI persistRepresentation(String cloudId, String representationName, String version) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/persist").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().post(Entity.entity(new Form(), MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    public void grantPermissionsToVersion(String cloudId, String representationName, String version, String userName, Permission permission) throws MCSException {
        Response.Status status = this.manageResponse(new MCSClient.ResponseParams<Response.Status>(Response.Status.class, new Response.Status[]{Response.Status.NOT_MODIFIED, Response.Status.OK}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/permissions/{permission}/users/{userName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("permission", permission.getValue()).resolveTemplate("userName", userName).request().post(null));
        if (status == Response.Status.NOT_MODIFIED) {
            throw new MCSException("Permissions not modified");
        }
    }

    public void revokePermissionsToVersion(String cloudId, String representationName, String version, String userName, Permission permission) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/permissions/{permission}/users/{userName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("permission", permission.getValue()).resolveTemplate("userName", userName).request().delete());
    }

    public void permitVersion(String cloudId, String representationName, String version) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/permit").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().post(null));
    }

    @Deprecated(since="6-SNAPSHOT")
    public List<Representation> getRepresentationsByRevision(String cloudId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp) throws MCSException {
        return this.getRepresentationsByRevision(cloudId, representationName, new Revision(revisionName, revisionProviderId, DateHelper.parseISODate(revisionTimestamp)));
    }

    public List<Representation> getRepresentationsByRevision(String cloudId, String representationName, Revision revision) throws MCSException {
        if (revision.getRevisionProviderId() == null) {
            throw new MCSException("RevisionProviderId is required");
        }
        return this.manageResponse(new MCSClient.ResponseParams<List<Representation>>(new GenericType<List<Representation>>(){}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/revisions/{revisionName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("revisionName", revision.getRevisionName()).queryParam("revisionProviderId", revision.getRevisionProviderId()).queryParam("revisionTimestamp", DateHelper.getISODateString(revision.getCreationTimeStamp())).request().get());
    }

    public List<Representation> getRepresentationsByRevision(String cloudId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp, String key, String value) throws MCSException {
        if (revisionProviderId == null) {
            throw new MCSException("RevisionProviderId is required");
        }
        return this.manageResponse(new MCSClient.ResponseParams<List<Representation>>(new GenericType<List<Representation>>(){}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/revisions/{revisionName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("revisionName", revisionName).queryParam("revisionProviderId", revisionProviderId).queryParam("revisionTimestamp", revisionTimestamp).request().header(key, value).get());
    }

    private FormDataMultiPart prepareRequestBody(String providerId, InputStream data, String fileName, String mediaType) {
        FormDataMultiPart requestBody = new FormDataMultiPart();
        requestBody.field("providerId", providerId).field("mimeType", mediaType).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
        if (fileName == null || fileName.trim().isEmpty()) {
            fileName = UUID.randomUUID().toString();
        }
        requestBody.field("fileName", fileName);
        return requestBody;
    }

    private void closeDataSources(InputStream data, MultiPart multiPartData) throws IOException {
        IOUtils.closeQuietly(data);
        if (multiPartData != null) {
            multiPartData.close();
        }
    }
}

