/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.response.CloudTagsResponse;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.mcs.driver.DataSetIterator;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.RepresentationIterator;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.commons.utils.DateHelper;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class DataSetServiceClient
extends MCSClient {
    public DataSetServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public DataSetServiceClient(String baseUrl, String authorization) {
        this(baseUrl, authorization, null, null, 20000, 60000);
    }

    public DataSetServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, null, username, password, 20000, 60000);
    }

    public DataSetServiceClient(String baseUrl, String authorizationHeader, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        if (authorizationHeader != null) {
            this.client.register(new ECloudBasicAuthFilter(authorizationHeader));
        } else if (username != null || password != null) {
            this.client.register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        }
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public ResultSlice<DataSet> getDataSetsForProviderChunk(String providerId, String startFrom) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets").resolveTemplate("providerId", providerId).queryParam("startFrom", startFrom).request().get());
    }

    public ResultSlice<DataSet> getDataSetsForProvider(String providerId) throws MCSException {
        return this.getDataSetsForProviderChunk(providerId, null);
    }

    public List<DataSet> getDataSetsForProviderList(String providerId) throws MCSException {
        ResultSlice<DataSet> resultSlice;
        ArrayList<DataSet> resultList = new ArrayList<DataSet>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetsForProviderChunk(providerId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public DataSetIterator getDataSetIteratorForProvider(String providerId) {
        return new DataSetIterator(this, providerId);
    }

    public URI createDataSet(String providerId, String dataSetId, String description) throws MCSException {
        Form form = new Form();
        form.param("dataSetId", dataSetId);
        form.param("description", description);
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets").resolveTemplate("providerId", providerId).request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    public ResultSlice<Representation> getDataSetRepresentationsChunk(String providerId, String dataSetId, String startFrom) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).queryParam("startFrom", startFrom).request().get());
    }

    public ResultSlice<Representation> getDataSetRepresentations(String providerId, String dataSetId) throws MCSException {
        return this.getDataSetRepresentationsChunk(providerId, dataSetId, null);
    }

    public List<Representation> getDataSetRepresentationsList(String providerId, String dataSetId) throws MCSException {
        ResultSlice<Representation> resultSlice;
        ArrayList<Representation> resultList = new ArrayList<Representation>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRepresentationsChunk(providerId, dataSetId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public RepresentationIterator getRepresentationIterator(String providerId, String dataSetId) {
        return new RepresentationIterator(this, providerId, dataSetId);
    }

    public void updateDescriptionOfDataSet(String providerId, String dataSetId, String description) throws MCSException {
        Form form = new Form();
        form.param("description", description);
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).request().put(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    public void deleteDataSet(String providerId, String dataSetId) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).request().delete());
    }

    public void assignRepresentationToDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version) throws MCSException {
        Form form = this.getForm(cloudId, representationName, version);
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    public void assignRepresentationToDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version, String key, String value) throws MCSException {
        Form form = this.getForm(cloudId, representationName, version);
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).request().header(key, value).post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    public void unassignRepresentationFromDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).queryParam("cloudId", cloudId).queryParam("representationName", representationName).queryParam("version", version).request().delete());
    }

    public List<CloudTagsResponse> getRevisionsWithDeletedFlagSetToFalse(String providerId, String dataSetId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp, int limit) throws MCSException {
        ResultSlice rs = this.manageResponse(new MCSClient.ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/representations/{representationName}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).resolveTemplate("representationName", representationName).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId).queryParam("revisionTimestamp", revisionTimestamp).queryParam("existingOnly", true).queryParam("limit", limit).request().get());
        return rs.getResults();
    }

    public ResultSlice<CloudTagsResponse> getDataSetRevisionsChunk(String providerId, String dataSetId, String representationName, Revision revision, String startFrom, Integer limit) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/representations/{representationName}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).resolveTemplate("representationName", representationName).resolveTemplate("revisionName", revision.getRevisionName()).resolveTemplate("revisionProviderId", revision.getRevisionProviderId()).queryParam("revisionTimestamp", DateHelper.getISODateString(revision.getCreationTimeStamp())).queryParam("startFrom", startFrom).queryParam("limit", limit != null ? limit : 0).request().get());
    }

    public ResultSlice<CloudTagsResponse> getDataSetRevisions(String providerId, String dataSetId, String representationName, Revision revision) throws MCSException {
        return this.getDataSetRevisionsChunk(providerId, dataSetId, representationName, revision, null, 0);
    }

    public List<CloudTagsResponse> getDataSetRevisionsList(String providerId, String dataSetId, String representationName, Revision revision) throws MCSException {
        ResultSlice<CloudTagsResponse> resultSlice;
        ArrayList<CloudTagsResponse> resultList = new ArrayList<CloudTagsResponse>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRevisionsChunk(providerId, dataSetId, representationName, revision, startFrom, null)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud ids and revision tags: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    private Form getForm(String cloudId, String representationName, String version) {
        Form form = new Form();
        form.param("cloudId", cloudId);
        form.param("representationName", representationName);
        form.param("version", version);
        return form;
    }
}

