/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.dps.rest;

import eu.europeana.cloud.common.model.dps.MetisDataset;
import eu.europeana.cloud.common.model.dps.NodeReport;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.exception.DPSClientException;
import eu.europeana.cloud.service.dps.exception.DPSExceptionProvider;
import eu.europeana.cloud.service.dps.exception.DpsException;
import eu.europeana.cloud.service.dps.metis.indexing.DataSetCleanerParameters;
import eu.europeana.cloud.service.dps.metis.indexing.TargetIndexingDatabase;
import eu.europeana.cloud.service.dps.metis.indexing.TargetIndexingEnvironment;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpsClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DpsClient.class);
    private static final String ERROR = "error";
    private static final String IDS_COUNT = "idsCount";
    private static final String TOPOLOGY_NAME = "TopologyName";
    private static final String TASK_ID = "TaskId";
    private static final String TASKS_URL = "/{TopologyName}/tasks";
    private static final String PERMIT_TOPOLOGY_URL = "/{TopologyName}/permit";
    private static final String TASK_URL = "/{TopologyName}/tasks/{TaskId}";
    private static final String REPORTS_RESOURCE = "reports";
    private static final String STATISTICS_RESOURCE = "statistics";
    private static final String KILL_TASK = "kill";
    private static final String TASK_PROGRESS_URL = "/{TopologyName}/tasks/{TaskId}/progress";
    private static final String TASK_CLEAN_DATASET_URL = "/{TopologyName}/tasks/{TaskId}/cleaner";
    private static final String DETAILED_TASK_REPORT_URL = "/{TopologyName}/tasks/{TaskId}/reports/details";
    private static final String ERRORS_TASK_REPORT_URL = "/{TopologyName}/tasks/{TaskId}/reports/errors";
    private static final String STATISTICS_REPORT_URL = "/{TopologyName}/tasks/{TaskId}/statistics";
    private static final String KILL_TASK_URL = "/{TopologyName}/tasks/{TaskId}/kill";
    private static final String ELEMENT_REPORT = "/{TopologyName}/tasks/{TaskId}/reports/element";
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MILLIS = 20000;
    private static final int DEFAULT_READ_TIMEOUT_IN_MILLIS = 60000;
    public static final String TASK_CANT_BE_KILLED_MESSAGE = "Task Can't be killed";
    private final String dpsUrl;
    private final Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).build();

    public DpsClient(String dpsUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this.client.register(HttpAuthenticationFeature.basic(username, password));
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
        this.dpsUrl = dpsUrl;
    }

    public DpsClient(String dpsUrl, String username, String password) {
        this(dpsUrl, username, password, 20000, 60000);
    }

    public DpsClient(String dpsUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
        this.dpsUrl = dpsUrl;
    }

    public DpsClient(String dpsUrl) {
        this(dpsUrl, 20000, 60000);
    }

    public long submitTask(DpsTask task, String topologyName) throws DpsException {
        URI uri = this.manageResponse(new ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.dpsUrl).path(TASKS_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).request().post(Entity.json(task)), "Submit Task Was not successful");
        return this.getTaskId(uri);
    }

    public void cleanMetisIndexingDataset(String topologyName, long taskId, DataSetCleanerParameters dataSetCleanerParameters, String key, String value) throws DpsException {
        this.manageResponse(new ResponseParams<Void>(Void.class), () -> this.client.target(this.dpsUrl).path(TASK_CLEAN_DATASET_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().header(key, value).post(Entity.json(dataSetCleanerParameters)), "Cleaning a dataset was not successful");
    }

    public Response.StatusType topologyPermit(String topologyName, String username) throws DpsException {
        Form form = new Form();
        form.param("username", username);
        return this.manageResponse(new ResponseParams<Response.StatusType>(Response.StatusType.class), () -> this.client.target(this.dpsUrl).path(PERMIT_TOPOLOGY_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)), "Granting permission was not successful");
    }

    public TaskInfo getTaskProgress(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<TaskInfo>(TaskInfo.class), () -> this.client.target(this.dpsUrl).path(TASK_PROGRESS_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().get(), "Task progress cannot be read");
    }

    public long getTotalMetisDatabaseRecords(String datasetId, TargetIndexingDatabase database) throws DpsException {
        return this.getTotalMetisDatabaseRecords(datasetId, database, TargetIndexingEnvironment.DEFAULT);
    }

    public long getTotalMetisDatabaseRecords(String datasetId, TargetIndexingDatabase database, TargetIndexingEnvironment environment2) throws DpsException {
        MetisDataset metisDataset = this.manageResponse(new ResponseParams<MetisDataset>(MetisDataset.class), () -> this.client.target(this.dpsUrl).path("/metis-datasets/{datasetId}").resolveTemplate("datasetId", datasetId).queryParam("database", new Object[]{database}).queryParam("altEnv", new Object[]{environment2}).request().get(), "Error while retrieving total metis database records");
        return metisDataset.getSize();
    }

    public List<SubTaskInfo> getDetailedTaskReport(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<List<SubTaskInfo>>(new GenericType<List<SubTaskInfo>>(){}), () -> this.client.target(this.dpsUrl).path(DETAILED_TASK_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().get(), "Error while retrieving detailed task report");
    }

    public List<SubTaskInfo> getDetailedTaskReportBetweenChunks(String topologyName, long taskId, int from, int to) throws DpsException {
        return this.manageResponse(new ResponseParams<List<SubTaskInfo>>(new GenericType<List<SubTaskInfo>>(){}), () -> this.client.target(this.dpsUrl).path(DETAILED_TASK_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).queryParam("from", from).queryParam("to", to).request().get(), "Error while retrieving detailed task report (witch chunks)");
    }

    public List<NodeReport> getElementReport(String topologyName, long taskId, String elementPath) throws DpsException {
        return this.manageResponse(new ResponseParams<List<NodeReport>>(new GenericType<List<NodeReport>>(){}), () -> this.client.target(this.dpsUrl).path(ELEMENT_REPORT).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).queryParam("path", elementPath).request().get(), "Error while retrieving reports element");
    }

    public TaskErrorsInfo getTaskErrorsReport(String topologyName, long taskId, String error, int idsCount) throws DpsException {
        return this.manageResponse(new ResponseParams<TaskErrorsInfo>(TaskErrorsInfo.class), () -> this.client.target(this.dpsUrl).path(ERRORS_TASK_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).queryParam(ERROR, error).queryParam(IDS_COUNT, idsCount).request().get(), "Error while retrieving task error report");
    }

    public boolean checkIfErrorReportExists(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<Response.StatusType>(Response.StatusType.class, Response.Status.OK, Response.Status.METHOD_NOT_ALLOWED), () -> this.client.target(this.dpsUrl).path(ERRORS_TASK_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().head(), "Error while checking error report exits").getStatusCode() == Response.Status.OK.getStatusCode();
    }

    public StatisticsReport getTaskStatisticsReport(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<StatisticsReport>(StatisticsReport.class), () -> this.client.target(this.dpsUrl).path(STATISTICS_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().get(), "Task statistics report cannot be read");
    }

    public String killTask(String topologyName, long taskId, String info) throws DpsException {
        if (info == null) {
            return this.killTask(topologyName, taskId);
        }
        return this.manageResponse(new ResponseParams<String>(String.class), () -> this.client.target(this.dpsUrl).path(KILL_TASK_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).queryParam("info", info).request().post(null), TASK_CANT_BE_KILLED_MESSAGE);
    }

    private String killTask(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<String>(String.class), () -> this.client.target(this.dpsUrl).path(KILL_TASK_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().post(null), TASK_CANT_BE_KILLED_MESSAGE);
    }

    @Override
    public void close() {
        this.client.close();
    }

    private long getTaskId(URI uri) {
        String[] elements = uri.getRawPath().split("/");
        return Long.parseLong(elements[elements.length - 1]);
    }

    private <T> T manageResponse(ResponseParams<T> responseParameters, Supplier<Response> responseSupplier, String errorMessage) throws DpsException {
        Response response = responseSupplier.get();
        try {
            response.bufferEntity();
            if (responseParameters.isStatusCodeValid(response.getStatus())) {
                T t = this.readEntityByClass(responseParameters, response);
                return t;
            }
            try {
                if (response.getStatus() == 503) {
                    throw DPSExceptionProvider.createException(errorMessage, "Service unavailable", new ServiceUnavailableException());
                }
                if (response.getStatus() == 404) {
                    throw DPSExceptionProvider.createException(errorMessage, "Endpoint not found", new NotFoundException());
                }
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw DPSExceptionProvider.createException(errorInfo);
            }
            catch (DPSClientException | DpsException dpsException) {
                throw dpsException;
            }
            catch (ProcessingException processingException) {
                String message = String.format("Could not deserialize response with statusCode: %d; message: %s", response.getStatus(), response.readEntity(String.class));
                throw DPSExceptionProvider.createException(errorMessage, message, processingException);
            }
            catch (Exception otherExceptions) {
                throw DPSExceptionProvider.createException(errorMessage, "Other exception", otherExceptions);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    private <T> T readEntityByClass(ResponseParams<T> responseParameters, Response response) {
        if (responseParameters.getExpectedClass() == Void.class) {
            return null;
        }
        if (responseParameters.getExpectedClass() == Boolean.class) {
            return (T)Boolean.TRUE;
        }
        if (responseParameters.getExpectedClass() == URI.class) {
            return (T)response.getLocation();
        }
        if (responseParameters.getExpectedClass() == Response.StatusType.class) {
            return (T)response.getStatusInfo();
        }
        if (responseParameters.getGenericType() != null) {
            return response.readEntity(responseParameters.getGenericType());
        }
        return response.readEntity(responseParameters.getExpectedClass());
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    protected void finalize() throws Throwable {
        LOGGER.warn("'{}.finalize()' called!!!\n{}", (Object)this.getClass().getSimpleName(), (Object)Thread.currentThread().getStackTrace());
        this.client.close();
    }

    private static class ResponseParams<T> {
        private Class<T> expectedClass;
        private GenericType<T> genericType;
        private Response.Status[] validStatuses;

        public ResponseParams(Class<T> expectedClass) {
            this(expectedClass, Response.Status.OK);
        }

        public ResponseParams(Class<T> expectedClass, Response.Status validStatus) {
            this(expectedClass, (GenericType<T>)null, new Response.Status[]{validStatus});
        }

        public ResponseParams(GenericType<T> genericType) {
            this(null, genericType, new Response.Status[]{Response.Status.OK});
        }

        public ResponseParams(Class<T> expectedClass, Response.Status ... validStatuses) {
            this(expectedClass, (GenericType<T>)null, validStatuses);
        }

        public boolean isStatusCodeValid(Integer statusCode) {
            return Arrays.stream(this.validStatuses).map(Response.Status::getStatusCode).anyMatch(statusCode::equals);
        }

        public ResponseParams(Class<T> expectedClass, GenericType<T> genericType, Response.Status[] validStatuses) {
            this.expectedClass = expectedClass;
            this.genericType = genericType;
            this.validStatuses = validStatuses;
        }

        public Class<T> getExpectedClass() {
            return this.expectedClass;
        }

        public GenericType<T> getGenericType() {
            return this.genericType;
        }

        public Response.Status[] getValidStatuses() {
            return this.validStatuses;
        }
    }
}

