/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontFactoryImp
implements FontProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontFactoryImp.class);
    private final Hashtable<String, String> trueTypeFonts = new Hashtable();
    private static String[] TTFamilyOrder = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};
    private final Hashtable<String, ArrayList<String>> fontFamilies = new Hashtable();
    public String defaultEncoding = "Cp1252";
    public boolean defaultEmbedding = false;

    public FontFactoryImp() {
        this.trueTypeFonts.put("Courier".toLowerCase(), "Courier");
        this.trueTypeFonts.put("Courier-Bold".toLowerCase(), "Courier-Bold");
        this.trueTypeFonts.put("Courier-Oblique".toLowerCase(), "Courier-Oblique");
        this.trueTypeFonts.put("Courier-BoldOblique".toLowerCase(), "Courier-BoldOblique");
        this.trueTypeFonts.put("Helvetica".toLowerCase(), "Helvetica");
        this.trueTypeFonts.put("Helvetica-Bold".toLowerCase(), "Helvetica-Bold");
        this.trueTypeFonts.put("Helvetica-Oblique".toLowerCase(), "Helvetica-Oblique");
        this.trueTypeFonts.put("Helvetica-BoldOblique".toLowerCase(), "Helvetica-BoldOblique");
        this.trueTypeFonts.put("Symbol".toLowerCase(), "Symbol");
        this.trueTypeFonts.put("Times-Roman".toLowerCase(), "Times-Roman");
        this.trueTypeFonts.put("Times-Bold".toLowerCase(), "Times-Bold");
        this.trueTypeFonts.put("Times-Italic".toLowerCase(), "Times-Italic");
        this.trueTypeFonts.put("Times-BoldItalic".toLowerCase(), "Times-BoldItalic");
        this.trueTypeFonts.put("ZapfDingbats".toLowerCase(), "ZapfDingbats");
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("Courier");
        tmp.add("Courier-Bold");
        tmp.add("Courier-Oblique");
        tmp.add("Courier-BoldOblique");
        this.fontFamilies.put("Courier".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Helvetica");
        tmp.add("Helvetica-Bold");
        tmp.add("Helvetica-Oblique");
        tmp.add("Helvetica-BoldOblique");
        this.fontFamilies.put("Helvetica".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Symbol");
        this.fontFamilies.put("Symbol".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Times-Roman");
        tmp.add("Times-Bold");
        tmp.add("Times-Italic");
        tmp.add("Times-BoldItalic");
        this.fontFamilies.put("Times".toLowerCase(), tmp);
        this.fontFamilies.put("Times-Roman".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("ZapfDingbats");
        this.fontFamilies.put("ZapfDingbats".toLowerCase(), tmp);
    }

    @Override
    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color) {
        return this.getFont(fontname, encoding, embedded, size, style, color, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color, boolean cached) {
        if (fontname == null) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        String lowercasefontname = fontname.toLowerCase();
        ArrayList<String> tmp = this.fontFamilies.get(lowercasefontname);
        if (tmp != null) {
            ArrayList<String> arrayList = tmp;
            synchronized (arrayList) {
                int s2 = style == -1 ? 0 : style;
                int fs = 0;
                boolean found = false;
                for (String f : tmp) {
                    String lcf = f.toLowerCase();
                    fs = 0;
                    if (lcf.indexOf("bold") != -1) {
                        fs |= 1;
                    }
                    if (lcf.indexOf("italic") != -1 || lcf.indexOf("oblique") != -1) {
                        fs |= 2;
                    }
                    if ((s2 & 3) != fs) continue;
                    fontname = f;
                    found = true;
                    break;
                }
                if (style != -1 && found) {
                    style &= ~fs;
                }
            }
        }
        BaseFont basefont = null;
        try {
            basefont = this.getBaseFont(fontname, encoding, embedded, cached);
            if (basefont == null) {
                return new Font(Font.FontFamily.UNDEFINED, size, style, color);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        catch (NullPointerException npe) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        return new Font(basefont, size, style, color);
    }

    protected BaseFont getBaseFont(String fontname, String encoding, boolean embedded, boolean cached) throws IOException, DocumentException {
        BaseFont basefont = null;
        try {
            basefont = BaseFont.createFont(fontname, encoding, embedded, cached, null, null, true);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        if (basefont == null && (fontname = this.trueTypeFonts.get(fontname.toLowerCase())) != null) {
            basefont = BaseFont.createFont(fontname, encoding, embedded, cached, null, null);
        }
        return basefont;
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style) {
        return this.getFont(fontname, encoding, embedded, size, style, null);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size) {
        return this.getFont(fontname, encoding, embedded, size, -1, null);
    }

    public Font getFont(String fontname, String encoding, boolean embedded) {
        return this.getFont(fontname, encoding, embedded, -1.0f, -1, null);
    }

    public Font getFont(String fontname, String encoding, float size, int style, BaseColor color) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, style, color);
    }

    public Font getFont(String fontname, String encoding, float size, int style) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, style, null);
    }

    public Font getFont(String fontname, String encoding, float size) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, -1, null);
    }

    public Font getFont(String fontname, float size, BaseColor color) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, -1, color);
    }

    public Font getFont(String fontname, String encoding) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    public Font getFont(String fontname, float size, int style, BaseColor color) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, style, color);
    }

    public Font getFont(String fontname, float size, int style) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, style, null);
    }

    public Font getFont(String fontname, float size) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, -1, null);
    }

    public Font getFont(String fontname) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFamily(String familyName, String fullName, String path) {
        ArrayList<String> tmp;
        if (path != null) {
            this.trueTypeFonts.put(fullName, path);
        }
        Cloneable cloneable = this.fontFamilies;
        synchronized (cloneable) {
            tmp = this.fontFamilies.get(familyName);
            if (tmp == null) {
                tmp = new ArrayList();
                this.fontFamilies.put(familyName, tmp);
            }
        }
        cloneable = tmp;
        synchronized (cloneable) {
            if (!tmp.contains(fullName)) {
                int fullNameLength = fullName.length();
                boolean inserted = false;
                for (int j = 0; j < tmp.size(); ++j) {
                    if (tmp.get(j).length() < fullNameLength) continue;
                    tmp.add(j, fullName);
                    inserted = true;
                    break;
                }
                if (!inserted) {
                    tmp.add(fullName);
                    String newFullName = fullName.toLowerCase();
                    if (newFullName.endsWith("regular")) {
                        newFullName = newFullName.substring(0, newFullName.length() - 7).trim();
                        tmp.add(0, fullName.substring(0, newFullName.length()));
                    }
                }
            }
        }
    }

    public void register(String path) {
        this.register(path, null);
    }

    public void register(String path, String alias) {
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().endsWith(".otf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                String[][] names;
                Object[] allNames = BaseFont.getAllFontNames(path, "Cp1252", null);
                this.trueTypeFonts.put(((String)allNames[0]).toLowerCase(), path);
                if (alias != null) {
                    String lcAlias = alias.toLowerCase();
                    this.trueTypeFonts.put(lcAlias, path);
                    if (lcAlias.endsWith("regular")) {
                        this.saveCopyOfRegularFont(lcAlias, path);
                    }
                }
                for (String[] name : names = (String[][])allNames[2]) {
                    String lcName = name[3].toLowerCase();
                    this.trueTypeFonts.put(lcName, path);
                    if (!lcName.endsWith("regular")) continue;
                    this.saveCopyOfRegularFont(lcName, path);
                }
                String fullName = null;
                String familyName = null;
                names = (String[][])allNames[1];
                block4: for (int k = 0; k < TTFamilyOrder.length; k += 3) {
                    for (String[] name : names) {
                        if (!TTFamilyOrder[k].equals(name[0]) || !TTFamilyOrder[k + 1].equals(name[1]) || !TTFamilyOrder[k + 2].equals(name[2])) continue;
                        familyName = name[3].toLowerCase();
                        k = TTFamilyOrder.length;
                        continue block4;
                    }
                }
                if (familyName != null) {
                    String lastName = "";
                    block6: for (String[] name : names = (String[][])allNames[2]) {
                        for (int k = 0; k < TTFamilyOrder.length; k += 3) {
                            if (!TTFamilyOrder[k].equals(name[0]) || !TTFamilyOrder[k + 1].equals(name[1]) || !TTFamilyOrder[k + 2].equals(name[2]) || (fullName = name[3]).equals(lastName)) continue;
                            lastName = fullName;
                            this.registerFamily(familyName, fullName, null);
                            continue block6;
                        }
                    }
                }
            } else if (path.toLowerCase().endsWith(".ttc")) {
                if (alias != null) {
                    LOGGER.error("You can't define an alias for a true type collection.");
                }
                String[] names = BaseFont.enumerateTTCNames(path);
                for (int i = 0; i < names.length; ++i) {
                    this.register(path + "," + i);
                }
            } else if (path.toLowerCase().endsWith(".afm") || path.toLowerCase().endsWith(".pfm")) {
                BaseFont bf = BaseFont.createFont(path, "Cp1252", false);
                String fullName = bf.getFullFontName()[0][3].toLowerCase();
                String familyName = bf.getFamilyFontName()[0][3].toLowerCase();
                String psName = bf.getPostscriptFontName().toLowerCase();
                this.registerFamily(familyName, fullName, null);
                this.trueTypeFonts.put(psName, path);
                this.trueTypeFonts.put(fullName, path);
            }
            if (LOGGER.isLogging(Level.TRACE)) {
                LOGGER.trace(String.format("Registered %s", path));
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    protected boolean saveCopyOfRegularFont(String regularFontName, String path) {
        String alias = regularFontName.substring(0, regularFontName.length() - 7).trim();
        if (!this.trueTypeFonts.containsKey(alias)) {
            this.trueTypeFonts.put(alias, path);
            return true;
        }
        return false;
    }

    public int registerDirectory(String dir) {
        return this.registerDirectory(dir, false);
    }

    public int registerDirectory(String dir, boolean scanSubdirectories) {
        if (LOGGER.isLogging(Level.DEBUG)) {
            LOGGER.debug(String.format("Registering directory %s, looking for fonts", dir));
        }
        int count = 0;
        try {
            File file = new File(dir);
            if (!file.exists() || !file.isDirectory()) {
                return 0;
            }
            String[] files = file.list();
            if (files == null) {
                return 0;
            }
            for (int k = 0; k < files.length; ++k) {
                try {
                    String suffix;
                    file = new File(dir, files[k]);
                    if (file.isDirectory()) {
                        if (!scanSubdirectories) continue;
                        count += this.registerDirectory(file.getAbsolutePath(), true);
                        continue;
                    }
                    String name = file.getPath();
                    String string = suffix = name.length() < 4 ? null : name.substring(name.length() - 4).toLowerCase();
                    if (".afm".equals(suffix) || ".pfm".equals(suffix)) {
                        File pfb = new File(name.substring(0, name.length() - 4) + ".pfb");
                        if (!pfb.exists()) continue;
                        this.register(name, null);
                        ++count;
                        continue;
                    }
                    if (!".ttf".equals(suffix) && !".otf".equals(suffix) && !".ttc".equals(suffix)) continue;
                    this.register(name, null);
                    ++count;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public int registerDirectories() {
        int count = 0;
        String windir = null;
        try {
            windir = System.getenv("windir");
        }
        catch (SecurityException e) {
            LOGGER.warn("Can't access System.getenv(\"windir\") to load fonts. Please, add RuntimePermission for getenv.windir.");
        }
        String fileseparator = System.getProperty("file.separator");
        if (windir != null && fileseparator != null) {
            count += this.registerDirectory(windir + fileseparator + "fonts");
        }
        count += this.registerDirectory("/usr/share/X11/fonts", true);
        count += this.registerDirectory("/usr/X/lib/X11/fonts", true);
        count += this.registerDirectory("/usr/openwin/lib/X11/fonts", true);
        count += this.registerDirectory("/usr/share/fonts", true);
        count += this.registerDirectory("/usr/X11R6/lib/X11/fonts", true);
        count += this.registerDirectory("/Library/Fonts");
        return count += this.registerDirectory("/System/Library/Fonts");
    }

    public Set<String> getRegisteredFonts() {
        return this.trueTypeFonts.keySet();
    }

    public Set<String> getRegisteredFamilies() {
        return this.fontFamilies.keySet();
    }

    @Override
    public boolean isRegistered(String fontname) {
        return this.trueTypeFonts.containsKey(fontname.toLowerCase());
    }
}

