/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.timestamp;

import com.github.f4b6a3.uuid.strategy.TimestampStrategy;
import com.github.f4b6a3.uuid.util.UuidTime;
import com.github.f4b6a3.uuid.util.internal.RandomUtil;

public final class DefaultTimestampStrategy
implements TimestampStrategy {
    private long prevTime = UuidTime.getCurrentTimestamp();
    private long prevTick = System.nanoTime() / 100L;
    private long accumulator = RandomUtil.nextLong() & 0xFFL;
    private static final long TICK_UNIT = 100L;
    private static final long ACCUMULATOR_LIMIT = 10000L;
    private static final long ACCUMULATOR_RESET = 255L;

    @Override
    public long getTimestamp() {
        long time = UuidTime.getCurrentTimestamp();
        long tick = System.nanoTime() / 100L;
        if (time == this.prevTime) {
            long elapsed = tick - this.prevTick;
            this.accumulator = elapsed > 1L && elapsed < 10000L - this.accumulator ? (this.accumulator += elapsed) : ++this.accumulator;
            if (this.accumulator >= 10000L) {
                while (time == UuidTime.getCurrentTimestamp()) {
                }
            }
        } else {
            ++this.accumulator;
            this.accumulator &= 0xFFL;
        }
        this.prevTime = time;
        this.prevTick = tick;
        return time + this.accumulator;
    }
}

