/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.MDC;

public class MDCFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        MDC.put("ip", request.getRemoteAddr());
        MDC.put("session", session == null ? "" : session.getId());
        try {
            chain.doFilter(request, response);
        }
        finally {
            MDC.remove("ip");
            MDC.remove("session");
        }
    }

    public void destroy() {
        MDC.clear();
    }
}

