/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.net.httpclient;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.TimerTask;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortHttpUriRequestTask
extends TimerTask {
    private Logger log = LoggerFactory.getLogger(AbortHttpUriRequestTask.class);
    private final Reference<HttpUriRequest> requestRef;

    public AbortHttpUriRequestTask(HttpUriRequest request) {
        this.requestRef = new SoftReference<HttpUriRequest>(request);
    }

    @Override
    public void run() {
        HttpUriRequest request = this.requestRef.get();
        if (request != null && !request.isAborted()) {
            this.log.info("aborting request to {}", (Object)request.getURI());
            request.abort();
        }
    }
}

