/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RangeInputStream
extends FilterInputStream {
    private long remaining;

    public RangeInputStream(InputStream in, long start) throws IOException {
        super(in);
        assert (start >= 0L);
        in.skip(start);
        this.remaining = -1L;
    }

    public RangeInputStream(InputStream in, long start, long end) throws IOException {
        super(in);
        assert (start >= 0L);
        assert (end > start);
        long skipped = in.skip(start);
        this.remaining = end - skipped;
    }

    @Override
    public int available() throws IOException {
        int av = this.in.available();
        if (this.remaining != -1L && av > (int)this.remaining) {
            return (int)this.remaining;
        }
        return av;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        if (this.remaining == -1L) {
            return this.in.read();
        }
        int out = this.in.read();
        --this.remaining;
        return out;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int out;
        if (this.remaining == 0L) {
            return -1;
        }
        if (this.remaining == -1L) {
            return this.in.read(b, off, len);
        }
        if ((long)len <= this.remaining) {
            out = this.in.read(b, off, len);
            this.remaining -= (long)len;
        } else {
            out = (int)this.remaining;
            this.in.read(b, off, (int)this.remaining);
            this.remaining = 0L;
        }
        return out;
    }
}

