/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.configuration;

import com.eaio.configuration.Configuration;
import com.eaio.util.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.log4j.helpers.OptionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConfiguration
extends ConcurrentSkipListMap<String, String>
implements Configuration {
    private static final long serialVersionUID = 3749446309723647414L;
    private transient Logger log = LoggerFactory.getLogger(this.getClass());

    public BaseConfiguration(String key) {
        this(key, true);
    }

    public BaseConfiguration(String key, boolean substitute) {
        this.load(key, substitute);
    }

    private void readObject(ObjectInputStream in) {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    private void load(String key, boolean substitute) {
        Properties p = new Properties();
        p.put("key", key);
        this.tryLoading(this.buildName(key, null), p);
        InetAddress[] localHosts = this.localHosts();
        int i = 0;
        while (i < localHosts.length) {
            this.tryLoading(this.buildName(key, localHosts[i].getHostName()), p);
            this.tryLoading(this.buildName(key, localHosts[i].getHostAddress()), p);
            ++i;
        }
        if (substitute) {
            this.substituteVariables(p);
        }
        for (String s2 : p.stringPropertyNames()) {
            this.put(s2, p.getProperty(s2));
        }
        this.log.debug("loaded configuration for {}", (Object)key);
    }

    private void substituteVariables(Properties p) {
        for (Object key : p.keySet()) {
            String val2 = p.getProperty((String)key);
            if (!val2.contains("${")) continue;
            p.setProperty((String)key, OptionConverter.substVars((String)val2, (Properties)p));
        }
    }

    private void tryLoading(String resource, Properties p) {
        block6: {
            String actualResource = new StrBuilder(resource.length() + 1).append('/').append(resource).toString();
            InputStream in = BaseConfiguration.class.getResourceAsStream(actualResource);
            if (in != null) {
                try {
                    try {
                        this.log.debug("loading from {}", (Object)actualResource);
                        p.load(in);
                    }
                    catch (IOException ex) {
                        this.log.warn("while loading " + actualResource + " from " + resource, ex);
                        Resource.close(in);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    Resource.close(in);
                    throw throwable;
                }
                Resource.close(in);
            }
        }
    }

    private String buildName(String key, String middle) {
        StrBuilder out = new StrBuilder();
        out.append(key);
        if (middle != null) {
            out.append('.');
            out.append(middle);
        }
        out.append(".properties");
        return out.toString();
    }

    private InetAddress[] localHosts() {
        InetAddress localHost = null;
        InetAddress[] out = null;
        try {
            localHost = InetAddress.getLocalHost();
            if (localHost != null) {
                out = InetAddress.getAllByName(localHost.getHostName());
            }
        }
        catch (UnknownHostException ex) {
            this.log.warn("unknown host", ex);
        }
        if (out == null) {
            out = localHost != null ? new InetAddress[]{localHost} : new InetAddress[]{};
        }
        return out;
    }
}

