/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.topologies.xslt;

import eu.europeana.cloud.service.dps.storm.io.ECloudTopologyPipeline;
import eu.europeana.cloud.service.dps.storm.topologies.properties.PropertyFileLoader;
import eu.europeana.cloud.service.dps.storm.topologies.xslt.bolt.XsltBolt;
import eu.europeana.cloud.service.dps.storm.utils.TopologyHelper;
import eu.europeana.cloud.service.dps.storm.utils.TopologyPropertiesValidator;
import eu.europeana.cloud.service.dps.storm.utils.TopologySubmitter;
import java.util.Map;
import java.util.Properties;
import org.apache.storm.Config;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.topology.IRichBolt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLTTopology {
    private static final Properties topologyProperties = new Properties();
    private static final String TOPOLOGY_PROPERTIES_FILE = "xslt-topology-config.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(XSLTTopology.class);

    public XSLTTopology(String defaultPropertyFile, String providedPropertyFile) {
        PropertyFileLoader.loadPropertyFile((String)defaultPropertyFile, (String)providedPropertyFile, (Properties)topologyProperties);
        TopologyPropertiesValidator.validateFor((String)"xslt_topology", (Properties)topologyProperties);
    }

    public StormTopology buildTopology() {
        return new ECloudTopologyPipeline("xslt_topology", topologyProperties).addReadFileBolt().addBolt("XSLT_BOLT", (IRichBolt)new XsltBolt(TopologyHelper.createCassandraProperties((Properties)topologyProperties)), "XSLT_BOLT_PARALLEL", "XSLT_BOLT_NUMBER_OF_TASKS").addWriteRecordBolt().addRevisionWriterBolt().buildTopology();
    }

    public static void main(String[] args) {
        try {
            LOGGER.info("Assembling '{}'", (Object)"xslt_topology");
            if (args.length <= 1) {
                String providedPropertyFile = args.length == 1 ? args[0] : "";
                XSLTTopology xsltTopology = new XSLTTopology(TOPOLOGY_PROPERTIES_FILE, providedPropertyFile);
                StormTopology stormTopology = xsltTopology.buildTopology();
                Config config = TopologyHelper.buildConfig((Properties)topologyProperties);
                String topologyName = topologyProperties.getProperty("TOPOLOGY_NAME");
                LOGGER.info("Submitting '{}'...", (Object)topologyName);
                TopologySubmitter.submitTopology((String)topologyName, (Map)config, (StormTopology)stormTopology);
            } else {
                LOGGER.error("Invalid number of parameters");
            }
        }
        catch (Exception e) {
            LOGGER.error("General error while setting up topology", (Throwable)e);
        }
    }
}

