/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.session;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFixationProtectionStrategy
implements SessionAuthenticationStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean migrateSessionAttributes = true;
    private List<String> retainedAttributes = null;
    private boolean alwaysCreateSession;

    @Override
    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        boolean hadSessionAlready;
        boolean bl = hadSessionAlready = request.getSession(false) != null;
        if (!hadSessionAlready && !this.alwaysCreateSession) {
            return;
        }
        HttpSession session = request.getSession();
        if (hadSessionAlready && request.isRequestedSessionIdValid()) {
            String originalSessionId = session.getId();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalidating session with Id '" + originalSessionId + "' " + (this.migrateSessionAttributes ? "and" : "without") + " migrating attributes.");
            }
            Map<String, Object> attributesToMigrate = this.extractAttributes(session);
            session.invalidate();
            session = request.getSession(true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Started new session: " + session.getId());
            }
            if (originalSessionId.equals(session.getId())) {
                this.logger.warn("Your servlet container did not change the session ID when a new session was created. You will not be adequately protected against session-fixation attacks");
            }
            this.transferAttributes(attributesToMigrate, session);
            this.onSessionChange(originalSessionId, session, authentication);
        }
    }

    protected void onSessionChange(String originalSessionId, HttpSession newSession, Authentication auth) {
    }

    protected Map<String, Object> extractAttributes(HttpSession session) {
        return this.createMigratedAttributeMap(session);
    }

    private void transferAttributes(Map<String, Object> attributes, HttpSession newSession) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                newSession.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    private HashMap<String, Object> createMigratedAttributeMap(HttpSession session) {
        HashMap<String, Object> attributesToMigrate;
        block3: {
            block2: {
                attributesToMigrate = null;
                if (!this.migrateSessionAttributes && this.retainedAttributes != null) break block2;
                attributesToMigrate = new HashMap<String, Object>();
                Enumeration enumer = session.getAttributeNames();
                while (enumer.hasMoreElements()) {
                    String key = (String)enumer.nextElement();
                    if (!this.migrateSessionAttributes && !key.startsWith("SPRING_SECURITY_")) continue;
                    attributesToMigrate.put(key, session.getAttribute(key));
                }
                break block3;
            }
            if (this.retainedAttributes.isEmpty()) break block3;
            attributesToMigrate = new HashMap();
            for (String name : this.retainedAttributes) {
                Object value = session.getAttribute(name);
                if (value == null) continue;
                attributesToMigrate.put(name, value);
            }
        }
        return attributesToMigrate;
    }

    public void setMigrateSessionAttributes(boolean migrateSessionAttributes) {
        this.migrateSessionAttributes = migrateSessionAttributes;
    }

    @Deprecated
    public void setRetainedAttributes(List<String> retainedAttributes) {
        this.logger.warn("Retained attributes is deprecated. Override the extractAttributes() method instead.");
        Assert.notNull(retainedAttributes);
        this.retainedAttributes = retainedAttributes;
    }

    public void setAlwaysCreateSession(boolean alwaysCreateSession) {
        this.alwaysCreateSession = alwaysCreateSession;
    }
}

