/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4;

import javax.transaction.TransactionManager;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.orm.hibernate4.SpringFlushSynchronization;
import org.springframework.orm.hibernate4.SpringJtaSessionContext;
import org.springframework.orm.hibernate4.SpringSessionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringSessionContext
implements CurrentSessionContext {
    private final SessionFactoryImplementor sessionFactory;
    private final CurrentSessionContext jtaSessionContext;

    public SpringSessionContext(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        JtaPlatform jtaPlatform = (JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class);
        TransactionManager transactionManager = jtaPlatform.retrieveTransactionManager();
        this.jtaSessionContext = transactionManager != null ? new SpringJtaSessionContext(sessionFactory) : null;
    }

    public Session currentSession() throws HibernateException {
        Object value = TransactionSynchronizationManager.getResource(this.sessionFactory);
        if (value instanceof Session) {
            return (Session)value;
        }
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)value;
            Session session = sessionHolder.getSession();
            if (TransactionSynchronizationManager.isSynchronizationActive() && !sessionHolder.isSynchronizedWithTransaction()) {
                TransactionSynchronizationManager.registerSynchronization(new SpringSessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory));
                sessionHolder.setSynchronizedWithTransaction(true);
                FlushMode flushMode = session.getFlushMode();
                if (FlushMode.isManualFlushMode((FlushMode)flushMode) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                    session.setFlushMode(FlushMode.AUTO);
                    sessionHolder.setPreviousFlushMode(flushMode);
                }
            }
            return session;
        }
        if (this.jtaSessionContext != null) {
            Session session = this.jtaSessionContext.currentSession();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.registerSynchronization(new SpringFlushSynchronization(session));
            }
            return session;
        }
        throw new HibernateException("No Session found for current thread");
    }
}

