/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.annotation;

import java.io.IOException;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSessionFactoryBean
extends LocalSessionFactoryBean
implements ResourceLoaderAware {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";
    private Class<?>[] annotatedClasses;
    private String[] annotatedPackages;
    private String[] packagesToScan;
    private TypeFilter[] entityTypeFilters = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false), new AnnotationTypeFilter(org.hibernate.annotations.Entity.class, false)};
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public AnnotationSessionFactoryBean() {
        this.setConfigurationClass(AnnotationConfiguration.class);
    }

    @Override
    public void setConfigurationClass(Class<?> configurationClass) {
        if (configurationClass == null || !AnnotationConfiguration.class.isAssignableFrom(configurationClass)) {
            throw new IllegalArgumentException("AnnotationSessionFactoryBean only supports AnnotationConfiguration or subclasses");
        }
        super.setConfigurationClass(configurationClass);
    }

    public void setAnnotatedClasses(Class<?> ... annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void setAnnotatedPackages(String ... annotatedPackages) {
        this.annotatedPackages = annotatedPackages;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void setEntityTypeFilters(TypeFilter ... entityTypeFilters) {
        this.entityTypeFilters = entityTypeFilters;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
    }

    @Override
    protected void postProcessMappings(Configuration config) throws HibernateException {
        AnnotationConfiguration annConfig = (AnnotationConfiguration)config;
        if (this.annotatedClasses != null) {
            for (Class<?> annotatedClass : this.annotatedClasses) {
                annConfig.addAnnotatedClass((Class)annotatedClass);
            }
        }
        if (this.annotatedPackages != null) {
            for (String annotatedPackage : this.annotatedPackages) {
                annConfig.addPackage(annotatedPackage);
            }
        }
        this.scanPackages(annConfig);
    }

    protected void scanPackages(AnnotationConfiguration config) {
        if (this.packagesToScan != null) {
            try {
                for (String pkg : this.packagesToScan) {
                    String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath(pkg) + RESOURCE_PATTERN;
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory(this.resourcePatternResolver);
                    for (Resource resource : resources) {
                        if (!resource.isReadable()) continue;
                        MetadataReader reader = readerFactory.getMetadataReader(resource);
                        String className = reader.getClassMetadata().getClassName();
                        if (this.matchesEntityTypeFilter(reader, readerFactory)) {
                            config.addAnnotatedClass(this.resourcePatternResolver.getClassLoader().loadClass(className));
                            continue;
                        }
                        if (!className.endsWith(PACKAGE_INFO_SUFFIX)) continue;
                        config.addPackage(className.substring(0, className.length() - PACKAGE_INFO_SUFFIX.length()));
                    }
                }
            }
            catch (IOException ex) {
                throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
            }
        }
    }

    private boolean matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.entityTypeFilters != null) {
            for (TypeFilter filter : this.entityTypeFilters) {
                if (!filter.match(reader, readerFactory)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void postProcessConfiguration(Configuration config) throws HibernateException {
        this.postProcessAnnotationConfiguration((AnnotationConfiguration)config);
    }

    protected void postProcessAnnotationConfiguration(AnnotationConfiguration config) throws HibernateException {
    }
}

