/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.IOException;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jibx.runtime.impl.XMLWriterNamespaceBase;

public class JDOMWriter
extends XMLWriterNamespaceBase {
    private Document document;
    private Element currentElement;

    public JDOMWriter(String[] namespaces) {
        super(namespaces);
        this.reset();
    }

    public JDOMWriter(String[] namespaces, Document document) {
        this(namespaces);
        this.document = document;
        if (document.hasRootElement()) {
            this.currentElement = document.getRootElement();
        }
    }

    public JDOMWriter(String[] namespaces, Element currentElement) {
        this(namespaces, currentElement.getDocument());
        this.currentElement = currentElement;
    }

    @Override
    public void init() {
    }

    @Override
    public void setIndentSpaces(int count, String newline, char indent) {
    }

    @Override
    public void writeXMLDecl(String version, String encoding, String standalone) throws IOException {
    }

    @Override
    public void startTagOpen(int index, String name) throws IOException {
        Element newElement = new Element(name, this.getNamespace(index));
        if (this.currentElement == null) {
            this.document.setRootElement(newElement);
        } else {
            this.currentElement.addContent(newElement);
        }
        this.currentElement = newElement;
    }

    @Override
    public void startTagNamespaces(int index, String name, int[] nums, String[] prefs) throws IOException {
        int[] deltas = this.openNamespaces(nums, prefs);
        this.startTagOpen(index, name);
        for (int i = 0; i < deltas.length; ++i) {
            int slot = deltas[i];
            this.currentElement.addNamespaceDeclaration(this.getNamespace(slot));
        }
    }

    @Override
    public void addAttribute(int index, String name, String value) throws IOException {
        this.currentElement.setAttribute(name, value, this.getNamespace(index));
    }

    @Override
    public void closeStartTag() throws IOException {
        this.incrementNesting();
    }

    @Override
    public void closeEmptyTag() throws IOException {
        this.incrementNesting();
        this.decrementNesting();
        this.currentElement = this.currentElement.getParentElement();
    }

    @Override
    public void startTagClosed(int index, String name) throws IOException {
        this.startTagOpen(index, name);
        this.closeStartTag();
    }

    @Override
    public void endTag(int index, String name) throws IOException {
        this.decrementNesting();
        this.currentElement = this.currentElement.getParentElement();
    }

    @Override
    public void writeTextContent(String text) throws IOException {
        this.currentElement.addContent(new Text(text));
    }

    @Override
    public void writeCData(String text) throws IOException {
        this.currentElement.addContent(new CDATA(text));
    }

    @Override
    public void writeComment(String text) throws IOException {
        this.currentElement.addContent(new Comment(text));
    }

    @Override
    public void writeEntityRef(String name) throws IOException {
        this.currentElement.addContent(new EntityRef(name));
    }

    @Override
    public void writeDocType(String name, String sys, String pub, String subset) throws IOException {
        DocType docType = null != pub ? new DocType(name, pub, sys) : (null != sys ? new DocType(name, sys) : new DocType(name));
        if (null != subset) {
            docType.setInternalSubset(subset);
        }
        this.document.setDocType(docType);
    }

    @Override
    public void writePI(String target, String data) throws IOException {
        this.currentElement.addContent(new ProcessingInstruction(target, data));
    }

    @Override
    public void indent() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void reset() {
        super.reset();
        this.document = new Document();
        this.currentElement = null;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    protected void defineNamespace(int index, String prefix) throws IOException {
    }

    @Override
    protected void undefineNamespace(int index) {
    }

    private Namespace getNamespace(int index) {
        String prefix = this.getNamespacePrefix(index);
        String uri = this.getNamespaceUri(index);
        if (prefix == null) {
            return Namespace.getNamespace(uri);
        }
        return Namespace.getNamespace(prefix, uri);
    }
}

