/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreConversionManager;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.oxm.IDResolver;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ReferenceResolver {
    private static final int MAP_INITIAL_CAPACITY = 64;
    private static final int LIST_INITIAL_CAPACITY = 8;
    private final ReferenceKey refKey;
    private LinkedHashMap<ReferenceKey, Reference> referencesMap = new LinkedHashMap(64);
    private List<Reference> unluckyReferences = new ArrayList<Reference>(64);
    private List<Integer> unluckyRefPositions = new ArrayList<Integer>(64);
    private Map<Class, Map<Object, Object>> cache = new HashMap<Class, Map<Object, Object>>(64);

    public ReferenceResolver() {
        this.refKey = new ReferenceKey();
    }

    private void resetContainers() {
        this.referencesMap = new LinkedHashMap(Math.max(this.referencesMap.size() / 2, 64));
        this.unluckyReferences = new ArrayList<Reference>(Math.max(this.unluckyReferences.size() / 2, 8));
        this.unluckyRefPositions = new ArrayList<Integer>(this.unluckyReferences.size());
        this.cache = new HashMap<Class, Map<Object, Object>>(Math.max(this.cache.size() / 2, 64));
    }

    public final void addReference(Reference ref) {
        ReferenceKey key = new ReferenceKey(ref);
        Reference previous = this.referencesMap.get(key);
        if (previous != null || ref.getSourceObject() instanceof Collection) {
            this.unluckyReferences.add(ref);
            this.unluckyRefPositions.add(this.referencesMap.size() + this.unluckyReferences.size() - 1);
        } else {
            this.referencesMap.put(key, ref);
        }
    }

    public final Reference getReference(ObjectReferenceMapping mapping, Object sourceObject) {
        this.refKey.setMapping(mapping);
        this.refKey.setSourceObject(sourceObject);
        Reference reference = this.referencesMap.get(this.refKey);
        if (reference != null) {
            return reference;
        }
        for (Reference reference1 : this.unluckyReferences) {
            if (reference1.getMapping() != mapping || reference1.getSourceObject() != sourceObject) continue;
            return reference1;
        }
        return null;
    }

    public final Reference getReference(ObjectReferenceMapping mapping, Object sourceObject, Field xmlField) {
        ReferenceKey key;
        Reference reference;
        Field targetField = (Field)mapping.getSourceToTargetKeyFieldAssociations().get(xmlField);
        String tgtXpath = null;
        if (mapping.getReferenceClass() != null && mapping.getReferenceClass() != Object.class && targetField != null) {
            tgtXpath = targetField.getXPath();
        }
        if ((reference = this.referencesMap.get(key = new ReferenceKey(sourceObject, mapping))) != null && reference.getPrimaryKeyMap().get(tgtXpath) == null) {
            return reference;
        }
        for (Reference reference1 : this.unluckyReferences) {
            if (reference1.getMapping() != mapping || reference1.getSourceObject() != sourceObject || reference1.getPrimaryKeyMap().get(tgtXpath) != null) continue;
            return reference1;
        }
        return null;
    }

    public final void putValue(Class clazz, Object key, Object object) {
        Map<Object, Object> keyToObject = this.cache.get(clazz);
        if (keyToObject == null) {
            keyToObject = new HashMap<Object, Object>();
            this.cache.put(clazz, keyToObject);
        }
        keyToObject.put(key, object);
    }

    public final void resolveReferences(CoreAbstractSession session, IDResolver userSpecifiedResolver, ErrorHandler handler) {
        Integer lastPosition;
        Collection<Reference> luckyReferences = this.referencesMap.values();
        Iterator<Reference> mapIterator = luckyReferences.iterator();
        Iterator<Reference> listIterator = this.unluckyReferences.iterator();
        boolean[] a = null;
        if (!this.unluckyReferences.isEmpty()) {
            lastPosition = this.unluckyRefPositions.get(this.unluckyRefPositions.size() - 1);
            a = new boolean[lastPosition + 1];
            for (Integer position : this.unluckyRefPositions) {
                a[position.intValue()] = true;
            }
        } else {
            lastPosition = -1;
        }
        int i = 0;
        int totalSize = luckyReferences.size() + this.unluckyReferences.size();
        while (i < totalSize) {
            Reference reference = i <= lastPosition && a[i] ? listIterator.next() : mapIterator.next();
            this.perform(session, userSpecifiedResolver, handler, reference);
            ++i;
        }
        this.resetContainers();
    }

    /*
     * Unable to fully structure code
     */
    private void perform(CoreAbstractSession session, IDResolver userSpecifiedResolver, ErrorHandler handler, Reference reference) {
        referenceSourceObject = reference.getSourceObject();
        if (reference.getMapping() instanceof CollectionReferenceMapping) {
            mapping = (CollectionReferenceMapping)reference.getMapping();
            cPolicy = mapping.getContainerPolicy();
            container = reference.getContainer();
            this.createPKVectorsFromMap(reference, mapping);
            if (reference.getPrimaryKey() == null) {
                return;
            }
            value = null;
            if (!mapping.isWriteOnly()) {
                for (E o : (Vector)reference.getPrimaryKey()) {
                    primaryKey = (CacheId)o;
                    if (userSpecifiedResolver != null) {
                        try {
                            if (primaryKey.getPrimaryKey().length > 1) {
                                idWrapper = new HashMap<String, Object>();
                                y = 0;
                                while (y < primaryKey.getPrimaryKey().length) {
                                    refMapping = (ObjectReferenceMapping)reference.getMapping();
                                    idName = refMapping.getReferenceDescriptor().getPrimaryKeyFieldNames().get(y);
                                    idValue = primaryKey.getPrimaryKey()[y];
                                    idWrapper.put(idName, idValue);
                                    ++y;
                                }
                                c = userSpecifiedResolver.resolve(idWrapper, reference.getTargetClass());
                            } else {
                                c = userSpecifiedResolver.resolve(primaryKey.getPrimaryKey()[0], reference.getTargetClass());
                            }
                            if (c == null) ** GOTO lbl35
                            value = c.call();
                        }
                        catch (Exception e) {
                            throw XMLMarshalException.unmarshalException(e);
                        }
                    } else {
                        value = this.getValue(session, reference, primaryKey, handler);
                    }
lbl35:
                    // 3 sources

                    if (value == null) continue;
                    cPolicy.addInto(value, container, (CoreAbstractSession)session);
                }
            }
            mapping.setAttributeValueInObject(referenceSourceObject, container);
            inverseReferenceMapping = mapping.getInverseReferenceMapping();
            if (inverseReferenceMapping != null && value != null) {
                backpointerAccessor = inverseReferenceMapping.getAttributeAccessor();
                backpointerContainerPolicy = inverseReferenceMapping.getContainerPolicy();
                if (backpointerContainerPolicy == null) {
                    backpointerAccessor.setAttributeValueInObject(value, referenceSourceObject);
                } else {
                    backpointerContainer = backpointerAccessor.getAttributeValueFromObject(value);
                    if (backpointerContainer == null) {
                        backpointerContainer = backpointerContainerPolicy.containerInstance();
                        backpointerAccessor.setAttributeValueInObject(value, backpointerContainer);
                    }
                    backpointerContainerPolicy.addInto(referenceSourceObject, backpointerContainer, (CoreAbstractSession)session);
                }
            }
        } else if (reference.getMapping() instanceof ObjectReferenceMapping) {
            primaryKey = (CacheId)reference.getPrimaryKey();
            value = null;
            if (userSpecifiedResolver != null) {
                try {
                    if (primaryKey.getPrimaryKey().length > 1) {
                        idWrapper = new HashMap<String, Object>();
                        y = 0;
                        while (y < primaryKey.getPrimaryKey().length) {
                            refMapping = (ObjectReferenceMapping)reference.getMapping();
                            idName = refMapping.getReferenceDescriptor().getPrimaryKeyFieldNames().get(y);
                            idValue = primaryKey.getPrimaryKey()[y];
                            idWrapper.put(idName, idValue);
                            ++y;
                        }
                        c = userSpecifiedResolver.resolve(idWrapper, reference.getTargetClass());
                    } else {
                        c = userSpecifiedResolver.resolve(primaryKey.getPrimaryKey()[0], reference.getTargetClass());
                    }
                    if (c == null) ** GOTO lbl79
                    value = c.call();
                }
                catch (Exception e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
            } else {
                value = this.getValue(session, reference, primaryKey, handler);
            }
lbl79:
            // 3 sources

            mapping = (ObjectReferenceMapping)reference.getMapping();
            if (value != null) {
                mapping.setAttributeValueInObject(reference.getSourceObject(), value);
            }
            if (reference.getSetting() != null) {
                reference.getSetting().setValue(value);
            }
            if ((inverseReferenceMapping = mapping.getInverseReferenceMapping()) != null) {
                backpointerAccessor = inverseReferenceMapping.getAttributeAccessor();
                backpointerContainerPolicy = inverseReferenceMapping.getContainerPolicy();
                if (backpointerContainerPolicy == null) {
                    backpointerAccessor.setAttributeValueInObject(value, referenceSourceObject);
                } else {
                    backpointerContainer = backpointerAccessor.getAttributeValueFromObject(value);
                    if (backpointerContainer == null) {
                        backpointerContainer = backpointerContainerPolicy.containerInstance();
                        backpointerAccessor.setAttributeValueInObject(value, backpointerContainer);
                    }
                    backpointerContainerPolicy.addInto(reference.getSourceObject(), backpointerContainer, (CoreAbstractSession)session);
                }
            }
        }
    }

    private void createPKVectorsFromMap(Reference reference, CollectionReferenceMapping mapping) {
        Object referenceDescriptor = mapping.getReferenceDescriptor();
        Vector<CacheId> pks = new Vector<CacheId>();
        if (referenceDescriptor == null) {
            CacheId pkVals = (CacheId)reference.getPrimaryKeyMap().get(null);
            if (pkVals == null) {
                return;
            }
            int x = 0;
            while (x < pkVals.getPrimaryKey().length) {
                Object[] values = new Object[]{pkVals.getPrimaryKey()[x]};
                pks.add(new CacheId(values));
                ++x;
            }
        } else {
            List<String> pkFields = ((CoreDescriptor)referenceDescriptor).getPrimaryKeyFieldNames();
            if (pkFields.isEmpty()) {
                return;
            }
            boolean init = true;
            for (String pkField : pkFields) {
                int i;
                CacheId pkVals = (CacheId)reference.getPrimaryKeyMap().get(pkField);
                if (pkVals == null) {
                    return;
                }
                if (init) {
                    i = 0;
                    while (i < pkVals.getPrimaryKey().length) {
                        pks.add(new CacheId(new Object[0]));
                        ++i;
                    }
                    init = false;
                }
                i = 0;
                while (i < pkVals.getPrimaryKey().length) {
                    Object val2 = pkVals.getPrimaryKey()[i];
                    ((CacheId)pks.get(i)).add(val2);
                    ++i;
                }
            }
        }
        reference.setPrimaryKey(pks);
    }

    private Object getValue(CoreAbstractSession session, Reference reference, CacheId primaryKey, ErrorHandler handler) {
        CoreMapping mapping;
        Object targetDescriptor;
        Class referenceTargetClass = reference.getTargetClass();
        if (referenceTargetClass == null || referenceTargetClass == CoreClassConstants.OBJECT) {
            for (Object entry : session.getDescriptors().values()) {
                Object value = null;
                Descriptor targetDescriptor2 = (Descriptor)entry;
                List pkFields = targetDescriptor2.getPrimaryKeyFields();
                if (pkFields == null || 1 != pkFields.size()) continue;
                Field pkField = (Field)pkFields.get(0);
                Class targetType = (pkField = targetDescriptor2.getTypedField(pkField)).getType();
                if (targetType == CoreClassConstants.STRING || targetType == CoreClassConstants.OBJECT) {
                    value = this.getValue(targetDescriptor2.getJavaClass(), primaryKey);
                } else {
                    try {
                        Object[] pkValues = primaryKey.getPrimaryKey();
                        Object[] convertedPkValues = new Object[pkValues.length];
                        int x = 0;
                        while (x < pkValues.length) {
                            convertedPkValues[x] = ((CoreConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(pkValues[x], targetType);
                            ++x;
                        }
                        value = this.getValue(targetDescriptor2.getJavaClass(), new CacheId(convertedPkValues));
                    }
                    catch (ConversionException conversionException) {}
                }
                if (value == null) continue;
                return value;
            }
            if (primaryKey.getPrimaryKey()[0] != null) {
                XMLMarshalException e = XMLMarshalException.missingIDForIDRef(Object.class.getName(), primaryKey.getPrimaryKey());
                if (handler != null) {
                    SAXParseException saxParseException = new SAXParseException(e.getLocalizedMessage(), null, e);
                    try {
                        handler.warning(saxParseException);
                    }
                    catch (SAXException sAXException) {
                        throw e;
                    }
                }
            }
            return null;
        }
        Object value = this.getValue(referenceTargetClass, primaryKey);
        if (value == null && ((CoreDescriptor)(targetDescriptor = (mapping = (CoreMapping)((Object)reference.getMapping())).getReferenceDescriptor())).hasInheritance()) {
            Object inheritancePolicy = ((CoreDescriptor)targetDescriptor).getInheritancePolicy();
            List childDescriptors = ((CoreInheritancePolicy)inheritancePolicy).getAllChildDescriptors();
            for (CoreDescriptor childDescriptor : childDescriptors) {
                value = this.getValue(childDescriptor.getJavaClass(), primaryKey);
                if (value == null) continue;
                return value;
            }
        }
        if (value == null && primaryKey.getPrimaryKey()[0] != null) {
            XMLMarshalException e = XMLMarshalException.missingIDForIDRef(referenceTargetClass.getName(), primaryKey.getPrimaryKey());
            if (handler != null) {
                SAXParseException saxParseException = new SAXParseException(e.getLocalizedMessage(), null, e);
                try {
                    handler.warning(saxParseException);
                }
                catch (SAXException sAXException) {
                    throw e;
                }
            }
        }
        return value;
    }

    private Object getValue(Class clazz, CacheId primaryKey) {
        Map<Object, Object> keyToObject = this.cache.get(clazz);
        if (keyToObject != null) {
            return keyToObject.get(primaryKey);
        }
        return null;
    }

    private static final class ReferenceKey {
        private Object sourceObject;
        private Mapping mapping;

        public ReferenceKey() {
        }

        public ReferenceKey(Object sourceObject, Mapping mapping) {
            this.sourceObject = sourceObject;
            this.mapping = mapping;
        }

        public ReferenceKey(Reference ref) {
            this.sourceObject = ref.getSourceObject();
            this.mapping = ref.getMapping();
        }

        public void setMapping(ObjectReferenceMapping mapping) {
            this.mapping = mapping;
        }

        public void setSourceObject(Object sourceObject) {
            this.sourceObject = sourceObject;
        }

        public final int hashCode() {
            int result = System.identityHashCode(this.sourceObject);
            result = 31 * result + System.identityHashCode(this.mapping);
            return result;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReferenceKey)) {
                return false;
            }
            ReferenceKey that = (ReferenceKey)o;
            return this.sourceObject == that.sourceObject && this.mapping == that.mapping;
        }
    }
}

