/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AggregateNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class SumNode
extends AggregateNode {
    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute(this.resolveAttribute(), this.generateExpression(context), this.calculateReturnType(context));
        }
    }

    @Override
    public void validate(ParseTreeContext context) {
        if (this.left != null) {
            this.left.validate(context);
            TypeHelper typeHelper = context.getTypeHelper();
            this.setType(this.calculateReturnType(this.left.getType(), typeHelper));
        }
    }

    @Override
    protected Expression addAggregateExression(Expression expr) {
        return expr.sum();
    }

    protected Class calculateReturnType(GenerationContext context) {
        Class returnType2 = null;
        if (this.getLeft().isDotNode()) {
            DotNode arg = (DotNode)this.getLeft();
            Class fieldType = arg.getTypeOfDirectToField(context);
            TypeHelper helper = context.getParseTreeContext().getTypeHelper();
            returnType2 = (Class)this.calculateReturnType(fieldType, helper);
        }
        return returnType2;
    }

    protected Object calculateReturnType(Object argType, TypeHelper helper) {
        Object returnType2 = null;
        if (helper.isIntegralType(argType)) {
            returnType2 = helper.getLongClassType();
        } else if (helper.isFloatingPointType(argType)) {
            returnType2 = helper.getDoubleClassType();
        } else if (helper.isBigIntegerType(argType)) {
            returnType2 = helper.getBigIntegerType();
        } else if (helper.isBigDecimalType(argType)) {
            returnType2 = helper.getBigDecimalType();
        }
        return returnType2;
    }

    @Override
    public String getAsString() {
        return "SUM(" + this.left.getAsString() + ")";
    }
}

