/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.Date;
import java.util.Random;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Shell;

public class Login {
    Logger LOG = Logger.getLogger(Login.class);
    public CallbackHandler callbackHandler;
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static final float TICKET_RENEW_JITTER = 0.05f;
    private static final long MIN_TIME_BEFORE_RELOGIN = 60000L;
    private Subject subject = null;
    private Thread t = null;
    private boolean isKrbTicket = false;
    private boolean isUsingTicketCache = false;
    private boolean isUsingKeytab = false;
    private static Random rng = new Random();
    private LoginContext login = null;
    private String loginContextName = null;
    private String keytabFile = null;
    private String principal = null;
    private long lastLogin = 0L;

    public Login(String loginContextName, CallbackHandler callbackHandler) throws LoginException {
        AppConfigurationEntry[] entries;
        this.callbackHandler = callbackHandler;
        this.login = this.login(loginContextName);
        this.loginContextName = loginContextName;
        this.subject = this.login.getSubject();
        this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        AppConfigurationEntry[] arr$ = entries = Configuration.getConfiguration().getAppConfigurationEntry(loginContextName);
        int len$ = arr$.length;
        int i$ = 0;
        if (i$ < len$) {
            String val2;
            AppConfigurationEntry entry = arr$[i$];
            if (entry.getOptions().get("useTicketCache") != null && (val2 = (String)entry.getOptions().get("useTicketCache")).equals("true")) {
                this.isUsingTicketCache = true;
            }
            if (entry.getOptions().get("keyTab") != null) {
                this.keytabFile = (String)entry.getOptions().get("keyTab");
                this.isUsingKeytab = true;
            }
            if (entry.getOptions().get("principal") != null) {
                this.principal = (String)entry.getOptions().get("principal");
            }
        }
        if (!this.isKrbTicket) {
            return;
        }
        this.t = new Thread(new Runnable(){

            public void run() {
                Login.this.LOG.info("TGT refresh thread started.");
                block12: while (true) {
                    block27: {
                        Date nextRefreshDate;
                        long nextRefresh;
                        KerberosTicket tgt = Login.this.getTGT();
                        long now = System.currentTimeMillis();
                        if (tgt == null) {
                            nextRefresh = now + 60000L;
                            nextRefreshDate = new Date(nextRefresh);
                            Login.this.LOG.warn("No TGT found: will try again at " + nextRefreshDate);
                        } else {
                            nextRefresh = Login.this.getRefreshTime(tgt);
                            long expiry = tgt.getEndTime().getTime();
                            Date expiryDate = new Date(expiry);
                            if (Login.this.isUsingTicketCache && tgt.getEndTime().equals(tgt.getRenewTill())) {
                                Login.this.LOG.error("The TGT cannot be renewed beyond the next expiry date: " + expiryDate + "." + "This process will not be able to authenticate new SASL connections after that " + "time (for example, it will not be authenticate a new connection with a Zookeeper " + "Quorum member).  Ask your system administrator to either increase the " + "'renew until' time by doing : 'modprinc -maxrenewlife " + Login.this.principal + "' within " + "kadmin, or instead, to generate a keytab for " + Login.this.principal + ". Because the TGT's " + "expiry cannot be further extended by refreshing, exiting refresh thread now.");
                                return;
                            }
                            if (nextRefresh > expiry || now + 60000L > expiry) {
                                Login.this.LOG.info("refreshing now because expiry is before next scheduled refresh time.");
                                nextRefresh = now;
                            } else {
                                if (nextRefresh < now + 60000L) {
                                    Date until = new Date(nextRefresh);
                                    Date newuntil = new Date(now + 60000L);
                                    Login.this.LOG.warn("TGT refresh thread time adjusted from : " + until + " to : " + newuntil + " since " + "the former is sooner than the minimum refresh interval (" + 60L + " seconds) from now.");
                                }
                                nextRefresh = Math.max(nextRefresh, now + 60000L);
                            }
                            nextRefreshDate = new Date(nextRefresh);
                            if (nextRefresh > expiry) {
                                Login.this.LOG.error("next refresh: " + nextRefreshDate + " is later than expiry " + expiryDate + ". This may indicate a clock skew problem. Check that this host and the KDC's " + "hosts' clocks are in sync. Exiting refresh thread.");
                                return;
                            }
                        }
                        if (now < nextRefresh) {
                            Date until = new Date(nextRefresh);
                            Login.this.LOG.info("TGT refresh sleeping until: " + until.toString());
                            try {
                                Thread.sleep(nextRefresh - now);
                                break block27;
                            }
                            catch (InterruptedException ie) {
                                Login.this.LOG.warn("TGT renewal thread has been interrupted and will exit.");
                                break;
                            }
                        }
                        Login.this.LOG.error("nextRefresh:" + nextRefreshDate + " is in the past: exiting refresh thread. Check" + " clock sync between this host and KDC - (KDC's clock is likely ahead of this host)." + " Manual intervention will be required for this client to successfully authenticate." + " Exiting refresh thread.");
                        return;
                    }
                    if (Login.this.isUsingTicketCache) {
                        String cmd = "/usr/bin/kinit";
                        if (System.getProperty("zookeeper.kinit") != null) {
                            cmd = System.getProperty("zookeeper.kinit");
                        }
                        String kinitArgs = "-R";
                        for (int retry = 1; retry >= 0; --retry) {
                            try {
                                Login.this.LOG.debug("running ticket cache refresh command: " + cmd + " " + kinitArgs);
                                Shell.execCommand(cmd, kinitArgs);
                                break;
                            }
                            catch (Exception e) {
                                if (retry > 0) {
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException ie) {
                                        Login.this.LOG.error("Interrupted while renewing TGT, exiting Login thread");
                                        return;
                                    }
                                }
                                Login.this.LOG.warn("Could not renew TGT due to problem running shell command: '" + cmd + " " + kinitArgs + "'" + "; exception was:" + e + ". Exiting refresh thread.", e);
                                return;
                            }
                        }
                    }
                    try {
                        int retry = 1;
                        while (true) {
                            if (retry < 0) continue block12;
                            try {
                                Login.this.reLogin();
                                continue block12;
                            }
                            catch (LoginException le) {
                                if (retry > 0) {
                                    --retry;
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        Login.this.LOG.error("Interrupted during login retry after LoginException:", le);
                                        throw le;
                                    }
                                }
                                Login.this.LOG.error("Could not refresh TGT for principal: " + Login.this.principal + ".", le);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (LoginException le) {
                        Login.this.LOG.error("Failed to refresh TGT: refresh thread exiting now.", le);
                        break;
                    }
                }
            }
        });
        this.t.setDaemon(true);
    }

    public void startThreadIfNeeded() {
        if (this.t != null) {
            this.t.start();
        }
    }

    public void shutdown() {
        if (this.t != null && this.t.isAlive()) {
            this.t.interrupt();
            try {
                this.t.join();
            }
            catch (InterruptedException e) {
                this.LOG.warn("error while waiting for Login thread to shutdown: " + e);
            }
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    private synchronized LoginContext login(String loginContextName) throws LoginException {
        if (loginContextName == null) {
            throw new LoginException("loginContext name (JAAS file section header) was null. Please check your java.security.login.auth.config (=" + System.getProperty("java.security.login.auth.config") + ") and your " + "zookeeper.sasl.clientconfig" + "(=" + System.getProperty("zookeeper.sasl.clientconfig", "Client") + ")");
        }
        LoginContext loginContext = new LoginContext(loginContextName, this.callbackHandler);
        loginContext.login();
        this.LOG.info("successfully logged in.");
        return loginContext;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        this.LOG.info("TGT valid starting at:        " + tgt.getStartTime().toString());
        this.LOG.info("TGT expires:                  " + tgt.getEndTime().toString());
        long proposedRefresh = start + (long)((double)(expires - start) * ((double)0.8f + (double)0.05f * rng.nextDouble()));
        if (proposedRefresh > expires) {
            return System.currentTimeMillis();
        }
        return proposedRefresh;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            this.LOG.debug("Found tgt " + ticket + ".");
            return ticket;
        }
        return null;
    }

    private boolean hasSufficientTimeElapsed() {
        long now = System.currentTimeMillis();
        if (now - this.getLastLogin() < 60000L) {
            this.LOG.warn("Not attempting to re-login since the last re-login was attempted less than 60 seconds before.");
            return false;
        }
        this.setLastLogin(now);
        return true;
    }

    private LoginContext getLogin() {
        return this.login;
    }

    private void setLogin(LoginContext login) {
        this.login = login;
    }

    private void setLastLogin(long time) {
        this.lastLogin = time;
    }

    private long getLastLogin() {
        return this.lastLogin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reLogin() throws LoginException {
        if (!this.isKrbTicket) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null) {
            throw new LoginException("login must be done first");
        }
        if (!this.hasSufficientTimeElapsed()) {
            return;
        }
        this.LOG.info("Initiating logout for " + this.principal);
        Class<Login> clazz = Login.class;
        synchronized (Login.class) {
            login.logout();
            login = new LoginContext(this.loginContextName, this.getSubject());
            this.LOG.info("Initiating re-login for " + this.principal);
            login.login();
            this.setLogin(login);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

