/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.trident;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.trident.KafkaTridentSpoutManager;
import org.apache.storm.kafka.spout.trident.TopicPartitionSerializer;
import org.apache.storm.trident.spout.IOpaquePartitionedTridentSpout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTridentSpoutOpaqueCoordinator<K, V>
implements IOpaquePartitionedTridentSpout.Coordinator<List<Map<String, Object>>>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTridentSpoutOpaqueCoordinator.class);
    private final TopicPartitionSerializer tpSerializer = new TopicPartitionSerializer();
    private final KafkaTridentSpoutManager<K, V> kafkaManager;

    public KafkaTridentSpoutOpaqueCoordinator(KafkaTridentSpoutManager<K, V> kafkaManager) {
        this.kafkaManager = kafkaManager;
        LOG.debug("Created {}", (Object)this.toString());
    }

    public boolean isReady(long txid) {
        LOG.debug("isReady = true");
        return true;
    }

    public List<Map<String, Object>> getPartitionsForBatch() {
        ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>(this.kafkaManager.getTopicPartitions());
        LOG.debug("TopicPartitions for batch {}", (Object)topicPartitions);
        ArrayList<Map<String, Object>> tps = new ArrayList<Map<String, Object>>();
        for (TopicPartition tp : topicPartitions) {
            tps.add(this.tpSerializer.toMap(tp));
        }
        return tps;
    }

    public void close() {
        LOG.debug("Closed");
    }

    public final String toString() {
        return super.toString() + "{kafkaManager=" + this.kafkaManager + '}';
    }
}

