/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.trident;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.trident.TopicPartitionSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTridentSpoutBatchMetadata
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTridentSpoutBatchMetadata.class);
    private static final TopicPartitionSerializer TP_SERIALIZER = new TopicPartitionSerializer();
    public static final String TOPIC_PARTITION_KEY = "tp";
    public static final String FIRST_OFFSET_KEY = "firstOffset";
    public static final String LAST_OFFSET_KEY = "lastOffset";
    private final TopicPartition topicPartition;
    private final long firstOffset;
    private final long lastOffset;

    public KafkaTridentSpoutBatchMetadata(TopicPartition topicPartition, long firstOffset, long lastOffset) {
        this.topicPartition = topicPartition;
        this.firstOffset = firstOffset;
        this.lastOffset = lastOffset;
    }

    public <K, V> KafkaTridentSpoutBatchMetadata(TopicPartition topicPartition, ConsumerRecords<K, V> consumerRecords) {
        Validate.notNull(consumerRecords.records(topicPartition));
        List<ConsumerRecord<K, V>> records = consumerRecords.records(topicPartition);
        Validate.isTrue(!records.isEmpty(), "There must be at least one record in order to build metadata");
        this.topicPartition = topicPartition;
        this.firstOffset = records.get(0).offset();
        this.lastOffset = records.get(records.size() - 1).offset();
        LOG.debug("Created {}", (Object)this.toString());
    }

    public long getFirstOffset() {
        return this.firstOffset;
    }

    public long getLastOffset() {
        return this.lastOffset;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public static KafkaTridentSpoutBatchMetadata fromMap(Map<String, Object> map) {
        Map topicPartitionMap = (Map)map.get(TOPIC_PARTITION_KEY);
        TopicPartition tp = TP_SERIALIZER.fromMap(topicPartitionMap);
        return new KafkaTridentSpoutBatchMetadata(tp, ((Number)map.get(FIRST_OFFSET_KEY)).longValue(), ((Number)map.get(LAST_OFFSET_KEY)).longValue());
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TOPIC_PARTITION_KEY, TP_SERIALIZER.toMap(this.topicPartition));
        map.put(FIRST_OFFSET_KEY, this.firstOffset);
        map.put(LAST_OFFSET_KEY, this.lastOffset);
        return map;
    }

    public final String toString() {
        return super.toString() + "{topicPartition=" + this.topicPartition + ", firstOffset=" + this.firstOffset + ", lastOffset=" + this.lastOffset + '}';
    }
}

