/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.ManualPartitioner;
import org.apache.storm.task.TopologyContext;

public class RoundRobinManualPartitioner
implements ManualPartitioner {
    @Override
    public List<TopicPartition> partition(List<TopicPartition> allPartitions, TopologyContext context) {
        int thisTaskIndex = context.getThisTaskIndex();
        int totalTaskCount = context.getComponentTasks(context.getThisComponentId()).size();
        HashSet<TopicPartition> myPartitions = new HashSet<TopicPartition>(allPartitions.size() / totalTaskCount + 1);
        for (int i = thisTaskIndex; i < allPartitions.size(); i += totalTaskCount) {
            myPartitions.add(allPartitions.get(i));
        }
        return new ArrayList<TopicPartition>(myPartitions);
    }
}

