/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.TopicFilter;

public class NamedTopicFilter
implements TopicFilter {
    private final Set<String> topics;

    public NamedTopicFilter(Set<String> topics) {
        this.topics = Collections.unmodifiableSet(topics);
    }

    public NamedTopicFilter(String ... topics) {
        this(new HashSet<String>(Arrays.asList(topics)));
    }

    @Override
    public List<TopicPartition> getFilteredTopicPartitions(KafkaConsumer<?, ?> consumer) {
        ArrayList<TopicPartition> allPartitions = new ArrayList<TopicPartition>();
        for (String topic : this.topics) {
            for (PartitionInfo partitionInfo : consumer.partitionsFor(topic)) {
                allPartitions.add(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
            }
        }
        return allPartitions;
    }

    @Override
    public String getTopicsString() {
        return StringUtils.join(this.topics, ",");
    }
}

