/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.ManualPartitioner;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.kafka.spout.TopicFilter;
import org.apache.storm.kafka.spout.TopicPartitionComparator;
import org.apache.storm.task.TopologyContext;

public class ManualPartitionSubscription
extends Subscription {
    private static final long serialVersionUID = 5633018073527583826L;
    private final ManualPartitioner partitioner;
    private final TopicFilter partitionFilter;
    private transient KafkaConsumer<?, ?> consumer = null;
    private transient ConsumerRebalanceListener listener = null;
    private transient TopologyContext context = null;

    public ManualPartitionSubscription(ManualPartitioner parter, TopicFilter partitionFilter) {
        this.partitionFilter = partitionFilter;
        this.partitioner = parter;
    }

    @Override
    public <K, V> void subscribe(KafkaConsumer<K, V> consumer, ConsumerRebalanceListener listener, TopologyContext context) {
        this.consumer = consumer;
        this.listener = listener;
        this.context = context;
        this.refreshAssignment();
    }

    @Override
    public void refreshAssignment() {
        List<TopicPartition> allPartitions = this.partitionFilter.getFilteredTopicPartitions(this.consumer);
        Collections.sort(allPartitions, TopicPartitionComparator.INSTANCE);
        HashSet<TopicPartition> newAssignment = new HashSet<TopicPartition>(this.partitioner.partition(allPartitions, this.context));
        Set<TopicPartition> currentAssignment = this.consumer.assignment();
        if (!newAssignment.equals(currentAssignment)) {
            this.listener.onPartitionsRevoked(currentAssignment);
            this.consumer.assign(newAssignment);
            this.listener.onPartitionsAssigned(newAssignment);
        }
    }

    @Override
    public String getTopicsString() {
        return this.partitionFilter.getTopicsString();
    }
}

