/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.layout;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.util.Transform;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="Log4j1XmlLayout", category="Core", elementType="layout", printObject=true)
public final class Log4j1XmlLayout
extends AbstractStringLayout {
    private final boolean locationInfo;
    private final boolean properties;

    @PluginFactory
    public static Log4j1XmlLayout createLayout(@PluginAttribute(value="locationInfo") boolean locationInfo, @PluginAttribute(value="properties") boolean properties) {
        return new Log4j1XmlLayout(locationInfo, properties);
    }

    private Log4j1XmlLayout(boolean locationInfo, boolean properties) {
        super(StandardCharsets.UTF_8);
        this.locationInfo = locationInfo;
        this.properties = properties;
    }

    public boolean isLocationInfo() {
        return this.locationInfo;
    }

    public boolean isProperties() {
        return this.properties;
    }

    @Override
    public void encode(LogEvent event, ByteBufferDestination destination) {
        StringBuilder text = Log4j1XmlLayout.getStringBuilder();
        this.formatTo(event, text);
        this.getStringBuilderEncoder().encode(text, destination);
    }

    @Override
    public String toSerializable(LogEvent event) {
        StringBuilder text = Log4j1XmlLayout.getStringBuilder();
        this.formatTo(event, text);
        return text.toString();
    }

    private void formatTo(LogEvent event, final StringBuilder buf) {
        ReadOnlyStringMap contextMap;
        StackTraceElement source;
        Throwable thrown;
        buf.append("<log4j:event logger=\"");
        buf.append(Transform.escapeHtmlTags(event.getLoggerName()));
        buf.append("\" timestamp=\"");
        buf.append(event.getTimeMillis());
        buf.append("\" level=\"");
        buf.append(Transform.escapeHtmlTags(String.valueOf(event.getLevel())));
        buf.append("\" thread=\"");
        buf.append(Transform.escapeHtmlTags(event.getThreadName()));
        buf.append("\">\r\n");
        buf.append("<log4j:message><![CDATA[");
        Transform.appendEscapingCData(buf, event.getMessage().getFormattedMessage());
        buf.append("]]></log4j:message>\r\n");
        List<String> ndc = event.getContextStack().asList();
        if (!ndc.isEmpty()) {
            buf.append("<log4j:NDC><![CDATA[");
            Transform.appendEscapingCData(buf, Strings.join(ndc, ' '));
            buf.append("]]></log4j:NDC>\r\n");
        }
        if ((thrown = event.getThrown()) != null) {
            buf.append("<log4j:throwable><![CDATA[");
            buf.append(thrown.toString());
            buf.append("\r\n");
            for (StackTraceElement element : thrown.getStackTrace()) {
                Transform.appendEscapingCData(buf, "\tat " + element.toString());
                buf.append("\r\n");
            }
            buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo && (source = event.getSource()) != null) {
            buf.append("<log4j:locationInfo class=\"");
            buf.append(Transform.escapeHtmlTags(source.getClassName()));
            buf.append("\" method=\"");
            buf.append(Transform.escapeHtmlTags(source.getMethodName()));
            buf.append("\" file=\"");
            buf.append(Transform.escapeHtmlTags(source.getFileName()));
            buf.append("\" line=\"");
            buf.append(source.getLineNumber());
            buf.append("\"/>\r\n");
        }
        if (this.properties && !(contextMap = event.getContextData()).isEmpty()) {
            buf.append("<log4j:properties>\r\n");
            contextMap.forEach(new BiConsumer<String, String>(){

                @Override
                public void accept(String key, String val2) {
                    if (val2 != null) {
                        buf.append("<log4j:data name=\"");
                        buf.append(Transform.escapeHtmlTags(key));
                        buf.append("\" value=\"");
                        buf.append(Transform.escapeHtmlTags(val2));
                        buf.append("\"/>\r\n");
                    }
                }
            });
            buf.append("</log4j:properties>\r\n");
        }
        buf.append("</log4j:event>\r\n\r\n");
    }
}

