/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;

public class SegmentURL {
    @XmlAttribute(name="media")
    private final String media;
    @XmlAttribute(name="mediaRange")
    private final String mediaRange;
    @XmlAttribute(name="index")
    private final String index;
    @XmlAttribute(name="indexRange")
    private final String indexRange;

    private SegmentURL(String media, String mediaRange, String index, String indexRange) {
        this.media = media;
        this.mediaRange = mediaRange;
        this.index = index;
        this.indexRange = indexRange;
    }

    private SegmentURL() {
        this.media = null;
        this.mediaRange = null;
        this.index = null;
        this.indexRange = null;
    }

    public String getMedia() {
        return this.media;
    }

    public String getMediaRange() {
        return this.mediaRange;
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentURL that = (SegmentURL)o;
        return Objects.equals(this.media, that.media) && Objects.equals(this.mediaRange, that.mediaRange) && Objects.equals(this.index, that.index) && Objects.equals(this.indexRange, that.indexRange);
    }

    public int hashCode() {
        return Objects.hash(this.media, this.mediaRange, this.index, this.indexRange);
    }

    public String toString() {
        return "SegmentURL{media='" + this.media + '\'' + ", mediaRange='" + this.mediaRange + '\'' + ", index='" + this.index + '\'' + ", indexRange='" + this.indexRange + '\'' + '}';
    }

    public Builder buildUpon() {
        return new Builder().withMedia(this.media).withMediaRange(this.mediaRange).withIndex(this.index).withIndexRange(this.indexRange);
    }

    public static class Builder {
        private String media;
        private String mediaRange;
        private String index;
        private String indexRange;

        public Builder withMedia(String media) {
            this.media = media;
            return this;
        }

        public Builder withMediaRange(String mediaRange) {
            this.mediaRange = mediaRange;
            return this;
        }

        public Builder withIndex(String index) {
            this.index = index;
            return this;
        }

        public Builder withIndexRange(String indexRange) {
            this.indexRange = indexRange;
            return this;
        }

        public SegmentURL build() {
            return new SegmentURL(this.media, this.mediaRange, this.index, this.indexRange);
        }
    }
}

