/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.lindstrom.mpd.data.Segment;
import io.lindstrom.mpd.data.URLType;
import io.lindstrom.mpd.support.Utils;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"initialization", "media", "startNumber", "timescale", "duration", "Initialization", "RepresentationIndex", "segmentTimeline", "BitstreamSwitching"})
public class SegmentTemplate {
    @XmlElement(name="S", namespace="urn:mpeg:dash:schema:mpd:2011")
    @XmlElementWrapper(name="SegmentTimeline", namespace="urn:mpeg:dash:schema:mpd:2011")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Segment> segmentTimeline;
    @XmlElement(name="BitstreamSwitching", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final URLType bitstreamswitchingElement;
    @XmlElement(name="Initialization", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final URLType initializationElement;
    @XmlElement(name="RepresentationIndex", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final URLType representationIndex;
    @XmlAttribute(name="media")
    private final String media;
    @XmlAttribute(name="index")
    private final String index;
    @XmlAttribute(name="initialization")
    private final String initialization;
    @XmlAttribute(name="bitstreamSwitching")
    private final String bitstreamSwitching;
    @XmlAttribute(name="duration")
    private final Long duration;
    @XmlAttribute(name="startNumber")
    private final Long startNumber;
    @XmlAttribute(name="timescale")
    private final Long timescale;
    @XmlAttribute(name="presentationTimeOffset")
    private final Long presentationTimeOffset;
    @XmlAttribute(name="indexRange")
    private final String indexRange;
    @XmlAttribute(name="indexRangeExact")
    private final Boolean indexRangeExact;
    @XmlAttribute(name="availabilityTimeOffset")
    private final Double availabilityTimeOffset;
    @XmlAttribute(name="availabilityTimeComplete")
    private final Boolean availabilityTimeComplete;

    private SegmentTemplate(List<Segment> segmentTimeline, URLType bitstreamswitchingElement, URLType initializationElement, URLType representationIndex, String media, String index, String initialization, String bitstreamSwitching, Long duration, Long startNumber, Long timescale, Long presentationTimeOffset, String indexRange, Boolean indexRangeExact, Double availabilityTimeOffset, Boolean availabilityTimeComplete) {
        this.segmentTimeline = segmentTimeline;
        this.bitstreamswitchingElement = bitstreamswitchingElement;
        this.initializationElement = initializationElement;
        this.representationIndex = representationIndex;
        this.media = media;
        this.index = index;
        this.initialization = initialization;
        this.bitstreamSwitching = bitstreamSwitching;
        this.duration = duration;
        this.startNumber = startNumber;
        this.timescale = timescale;
        this.presentationTimeOffset = presentationTimeOffset;
        this.indexRange = indexRange;
        this.indexRangeExact = indexRangeExact;
        this.availabilityTimeOffset = availabilityTimeOffset;
        this.availabilityTimeComplete = availabilityTimeComplete;
    }

    private SegmentTemplate() {
        this.segmentTimeline = null;
        this.bitstreamswitchingElement = null;
        this.initializationElement = null;
        this.representationIndex = null;
        this.media = null;
        this.index = null;
        this.initialization = null;
        this.bitstreamSwitching = null;
        this.duration = null;
        this.startNumber = null;
        this.timescale = null;
        this.presentationTimeOffset = null;
        this.indexRange = null;
        this.indexRangeExact = null;
        this.availabilityTimeOffset = null;
        this.availabilityTimeComplete = null;
    }

    public List<Segment> getSegmentTimeline() {
        return Utils.unmodifiableList(this.segmentTimeline);
    }

    public URLType getBitstreamswitchingElement() {
        return this.bitstreamswitchingElement;
    }

    public URLType getInitializationElement() {
        return this.initializationElement;
    }

    public URLType getRepresentationIndex() {
        return this.representationIndex;
    }

    public String getMedia() {
        return this.media;
    }

    public String getIndex() {
        return this.index;
    }

    public String getInitialization() {
        return this.initialization;
    }

    public String getBitstreamSwitching() {
        return this.bitstreamSwitching;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getStartNumber() {
        return this.startNumber;
    }

    public Long getTimescale() {
        return this.timescale;
    }

    public Long getPresentationTimeOffset() {
        return this.presentationTimeOffset;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public Boolean getIndexRangeExact() {
        return this.indexRangeExact;
    }

    public Double getAvailabilityTimeOffset() {
        return this.availabilityTimeOffset;
    }

    public Boolean getAvailabilityTimeComplete() {
        return this.availabilityTimeComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentTemplate that = (SegmentTemplate)o;
        return Objects.equals(this.segmentTimeline, that.segmentTimeline) && Objects.equals(this.bitstreamswitchingElement, that.bitstreamswitchingElement) && Objects.equals(this.initializationElement, that.initializationElement) && Objects.equals(this.representationIndex, that.representationIndex) && Objects.equals(this.media, that.media) && Objects.equals(this.index, that.index) && Objects.equals(this.initialization, that.initialization) && Objects.equals(this.bitstreamSwitching, that.bitstreamSwitching) && Objects.equals(this.duration, that.duration) && Objects.equals(this.startNumber, that.startNumber) && Objects.equals(this.timescale, that.timescale) && Objects.equals(this.presentationTimeOffset, that.presentationTimeOffset) && Objects.equals(this.indexRange, that.indexRange) && Objects.equals(this.indexRangeExact, that.indexRangeExact) && Objects.equals(this.availabilityTimeOffset, that.availabilityTimeOffset) && Objects.equals(this.availabilityTimeComplete, that.availabilityTimeComplete);
    }

    public int hashCode() {
        return Objects.hash(this.segmentTimeline, this.bitstreamswitchingElement, this.initializationElement, this.representationIndex, this.media, this.index, this.initialization, this.bitstreamSwitching, this.duration, this.startNumber, this.timescale, this.presentationTimeOffset, this.indexRange, this.indexRangeExact, this.availabilityTimeOffset, this.availabilityTimeComplete);
    }

    public String toString() {
        return "SegmentTemplate{segmentTimeline=" + this.segmentTimeline + ", bitstreamswitchingElement=" + this.bitstreamswitchingElement + ", initializationElement=" + this.initializationElement + ", representationIndex=" + this.representationIndex + ", media='" + this.media + '\'' + ", index='" + this.index + '\'' + ", initialization='" + this.initialization + '\'' + ", bitstreamSwitching='" + this.bitstreamSwitching + '\'' + ", duration=" + this.duration + ", startNumber=" + this.startNumber + ", timescale=" + this.timescale + ", presentationTimeOffset=" + this.presentationTimeOffset + ", indexRange='" + this.indexRange + '\'' + ", indexRangeExact=" + this.indexRangeExact + ", availabilityTimeOffset=" + this.availabilityTimeOffset + ", availabilityTimeComplete=" + this.availabilityTimeComplete + '}';
    }

    public Builder buildUpon() {
        return new Builder().withSegmentTimeline(this.segmentTimeline).withBitstreamswitchingElement(this.bitstreamswitchingElement).withInitializationElement(this.initializationElement).withRepresentationIndex(this.representationIndex).withMedia(this.media).withIndex(this.index).withInitialization(this.initialization).withBitstreamSwitching(this.bitstreamSwitching).withDuration(this.duration).withStartNumber(this.startNumber).withTimescale(this.timescale).withPresentationTimeOffset(this.presentationTimeOffset).withIndexRange(this.indexRange).withIndexRangeExact(this.indexRangeExact).withAvailabilityTimeOffset(this.availabilityTimeOffset).withAvailabilityTimeComplete(this.availabilityTimeComplete);
    }

    public static class Builder {
        private List<Segment> segmentTimeline;
        private URLType bitstreamswitchingElement;
        private URLType initializationElement;
        private URLType representationIndex;
        private String media;
        private String index;
        private String initialization;
        private String bitstreamSwitching;
        private Long duration;
        private Long startNumber;
        private Long timescale;
        private Long presentationTimeOffset;
        private String indexRange;
        private Boolean indexRangeExact;
        private Double availabilityTimeOffset;
        private Boolean availabilityTimeComplete;

        public Builder withSegmentTimeline(List<Segment> segmentTimeline) {
            this.segmentTimeline = segmentTimeline;
            return this;
        }

        public Builder withBitstreamswitchingElement(URLType bitstreamswitchingElement) {
            this.bitstreamswitchingElement = bitstreamswitchingElement;
            return this;
        }

        public Builder withInitializationElement(URLType initializationElement) {
            this.initializationElement = initializationElement;
            return this;
        }

        public Builder withRepresentationIndex(URLType representationIndex) {
            this.representationIndex = representationIndex;
            return this;
        }

        public Builder withMedia(String media) {
            this.media = media;
            return this;
        }

        public Builder withIndex(String index) {
            this.index = index;
            return this;
        }

        public Builder withInitialization(String initialization) {
            this.initialization = initialization;
            return this;
        }

        public Builder withBitstreamSwitching(String bitstreamSwitching) {
            this.bitstreamSwitching = bitstreamSwitching;
            return this;
        }

        public Builder withDuration(Long duration) {
            this.duration = duration;
            return this;
        }

        public Builder withStartNumber(Long startNumber) {
            this.startNumber = startNumber;
            return this;
        }

        public Builder withTimescale(Long timescale) {
            this.timescale = timescale;
            return this;
        }

        public Builder withPresentationTimeOffset(Long presentationTimeOffset) {
            this.presentationTimeOffset = presentationTimeOffset;
            return this;
        }

        public Builder withIndexRange(String indexRange) {
            this.indexRange = indexRange;
            return this;
        }

        public Builder withIndexRangeExact(Boolean indexRangeExact) {
            this.indexRangeExact = indexRangeExact;
            return this;
        }

        public Builder withAvailabilityTimeOffset(Double availabilityTimeOffset) {
            this.availabilityTimeOffset = availabilityTimeOffset;
            return this;
        }

        public Builder withAvailabilityTimeComplete(Boolean availabilityTimeComplete) {
            this.availabilityTimeComplete = availabilityTimeComplete;
            return this;
        }

        public SegmentTemplate build() {
            return new SegmentTemplate(this.segmentTimeline, this.bitstreamswitchingElement, this.initializationElement, this.representationIndex, this.media, this.index, this.initialization, this.bitstreamSwitching, this.duration, this.startNumber, this.timescale, this.presentationTimeOffset, this.indexRange, this.indexRangeExact, this.availabilityTimeOffset, this.availabilityTimeComplete);
        }
    }
}

