/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.lindstrom.mpd.data.ActuateType;
import io.lindstrom.mpd.data.Segment;
import io.lindstrom.mpd.data.SegmentURL;
import io.lindstrom.mpd.data.URLType;
import io.lindstrom.mpd.support.Utils;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class SegmentList {
    @XmlElement(name="Initialization", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final URLType initialization;
    @XmlElement(name="RepresentationIndex", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final URLType representationIndex;
    @XmlElement(name="S", namespace="urn:mpeg:dash:schema:mpd:2011")
    @XmlElementWrapper(name="SegmentTimeline", namespace="urn:mpeg:dash:schema:mpd:2011")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Segment> segmentTimeline;
    @XmlElement(name="BitstreamSwitching", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final URLType bitstreamswitchingElement;
    @XmlElement(name="SegmentURL", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<SegmentURL> segmentURLs;
    @XmlAttribute(name="duration")
    private final Long duration;
    @XmlAttribute(name="startNumber")
    private final Long startNumber;
    @XmlAttribute(name="href", namespace="http://www.w3.org/1999/xlink")
    private final String href;
    @XmlAttribute(name="actuate", namespace="http://www.w3.org/1999/xlink")
    private final ActuateType actuate;
    @XmlAttribute(name="timescale")
    private final Long timescale;
    @XmlAttribute(name="presentationTimeOffset")
    private final Long presentationTimeOffset;
    @XmlAttribute(name="indexRange")
    private final String indexRange;
    @XmlAttribute(name="indexRangeExact")
    private final Boolean indexRangeExact;
    @XmlAttribute(name="availabilityTimeOffset")
    private final Double availabilityTimeOffset;
    @XmlAttribute(name="availabilityTimeComplete")
    private final Boolean availabilityTimeComplete;

    private SegmentList(URLType initialization, URLType representationIndex, List<Segment> segmentTimeline, URLType bitstreamswitchingElement, List<SegmentURL> segmentURLs, Long duration, Long startNumber, String href, ActuateType actuate, Long timescale, Long presentationTimeOffset, String indexRange, Boolean indexRangeExact, Double availabilityTimeOffset, Boolean availabilityTimeComplete) {
        this.initialization = initialization;
        this.representationIndex = representationIndex;
        this.segmentTimeline = segmentTimeline;
        this.bitstreamswitchingElement = bitstreamswitchingElement;
        this.segmentURLs = segmentURLs;
        this.duration = duration;
        this.startNumber = startNumber;
        this.href = href;
        this.actuate = actuate;
        this.timescale = timescale;
        this.presentationTimeOffset = presentationTimeOffset;
        this.indexRange = indexRange;
        this.indexRangeExact = indexRangeExact;
        this.availabilityTimeOffset = availabilityTimeOffset;
        this.availabilityTimeComplete = availabilityTimeComplete;
    }

    private SegmentList() {
        this.initialization = null;
        this.representationIndex = null;
        this.segmentTimeline = null;
        this.bitstreamswitchingElement = null;
        this.segmentURLs = null;
        this.duration = null;
        this.startNumber = null;
        this.href = null;
        this.actuate = null;
        this.timescale = null;
        this.presentationTimeOffset = null;
        this.indexRange = null;
        this.indexRangeExact = null;
        this.availabilityTimeOffset = null;
        this.availabilityTimeComplete = null;
    }

    public URLType getInitialization() {
        return this.initialization;
    }

    public URLType getRepresentationIndex() {
        return this.representationIndex;
    }

    public List<Segment> getSegmentTimeline() {
        return Utils.unmodifiableList(this.segmentTimeline);
    }

    public URLType getBitstreamswitchingElement() {
        return this.bitstreamswitchingElement;
    }

    public List<SegmentURL> getSegmentURLs() {
        return Utils.unmodifiableList(this.segmentURLs);
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getStartNumber() {
        return this.startNumber;
    }

    public String getHref() {
        return this.href;
    }

    public ActuateType getActuate() {
        return this.actuate;
    }

    public Long getTimescale() {
        return this.timescale;
    }

    public Long getPresentationTimeOffset() {
        return this.presentationTimeOffset;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public Boolean getIndexRangeExact() {
        return this.indexRangeExact;
    }

    public Double getAvailabilityTimeOffset() {
        return this.availabilityTimeOffset;
    }

    public Boolean getAvailabilityTimeComplete() {
        return this.availabilityTimeComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentList that = (SegmentList)o;
        return Objects.equals(this.initialization, that.initialization) && Objects.equals(this.representationIndex, that.representationIndex) && Objects.equals(this.segmentTimeline, that.segmentTimeline) && Objects.equals(this.bitstreamswitchingElement, that.bitstreamswitchingElement) && Objects.equals(this.segmentURLs, that.segmentURLs) && Objects.equals(this.duration, that.duration) && Objects.equals(this.startNumber, that.startNumber) && Objects.equals(this.href, that.href) && this.actuate == that.actuate && Objects.equals(this.timescale, that.timescale) && Objects.equals(this.presentationTimeOffset, that.presentationTimeOffset) && Objects.equals(this.indexRange, that.indexRange) && Objects.equals(this.indexRangeExact, that.indexRangeExact) && Objects.equals(this.availabilityTimeOffset, that.availabilityTimeOffset) && Objects.equals(this.availabilityTimeComplete, that.availabilityTimeComplete);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.initialization, this.representationIndex, this.segmentTimeline, this.bitstreamswitchingElement, this.segmentURLs, this.duration, this.startNumber, this.href, this.actuate, this.timescale, this.presentationTimeOffset, this.indexRange, this.indexRangeExact, this.availabilityTimeOffset, this.availabilityTimeComplete});
    }

    public String toString() {
        return "SegmentList{initialization=" + this.initialization + ", representationIndex=" + this.representationIndex + ", segmentTimeline=" + this.segmentTimeline + ", bitstreamswitchingElement=" + this.bitstreamswitchingElement + ", segmentURLs=" + this.segmentURLs + ", duration=" + this.duration + ", startNumber=" + this.startNumber + ", href='" + this.href + '\'' + ", actuate=" + (Object)((Object)this.actuate) + ", timescale=" + this.timescale + ", presentationTimeOffset=" + this.presentationTimeOffset + ", indexRange='" + this.indexRange + '\'' + ", indexRangeExact=" + this.indexRangeExact + ", availabilityTimeOffset=" + this.availabilityTimeOffset + ", availabilityTimeComplete=" + this.availabilityTimeComplete + '}';
    }

    public Builder buildUpon() {
        return new Builder().withInitialization(this.initialization).withRepresentationIndex(this.representationIndex).withSegmentTimeline(this.segmentTimeline).withBitstreamswitchingElement(this.bitstreamswitchingElement).withSegmentURLs(this.segmentURLs).withDuration(this.duration).withStartNumber(this.startNumber).withHref(this.href).withActuate(this.actuate).withTimescale(this.timescale).withPresentationTimeOffset(this.presentationTimeOffset).withIndexRange(this.indexRange).withIndexRangeExact(this.indexRangeExact).withAvailabilityTimeOffset(this.availabilityTimeOffset).withAvailabilityTimeComplete(this.availabilityTimeComplete);
    }

    public static class Builder {
        private URLType initialization;
        private URLType representationIndex;
        private List<Segment> segmentTimeline;
        private URLType bitstreamswitchingElement;
        private List<SegmentURL> segmentURLs;
        private Long duration;
        private Long startNumber;
        private String href;
        private ActuateType actuate;
        private Long timescale;
        private Long presentationTimeOffset;
        private String indexRange;
        private Boolean indexRangeExact;
        private Double availabilityTimeOffset;
        private Boolean availabilityTimeComplete;

        public Builder withInitialization(URLType initialization) {
            this.initialization = initialization;
            return this;
        }

        public Builder withRepresentationIndex(URLType representationIndex) {
            this.representationIndex = representationIndex;
            return this;
        }

        public Builder withSegmentTimeline(List<Segment> segmentTimeline) {
            this.segmentTimeline = segmentTimeline;
            return this;
        }

        public Builder withBitstreamswitchingElement(URLType bitstreamswitchingElement) {
            this.bitstreamswitchingElement = bitstreamswitchingElement;
            return this;
        }

        public Builder withSegmentURLs(List<SegmentURL> segmentURLs) {
            this.segmentURLs = segmentURLs;
            return this;
        }

        public Builder withDuration(Long duration) {
            this.duration = duration;
            return this;
        }

        public Builder withStartNumber(Long startNumber) {
            this.startNumber = startNumber;
            return this;
        }

        public Builder withHref(String href) {
            this.href = href;
            return this;
        }

        public Builder withActuate(ActuateType actuate) {
            this.actuate = actuate;
            return this;
        }

        public Builder withTimescale(Long timescale) {
            this.timescale = timescale;
            return this;
        }

        public Builder withPresentationTimeOffset(Long presentationTimeOffset) {
            this.presentationTimeOffset = presentationTimeOffset;
            return this;
        }

        public Builder withIndexRange(String indexRange) {
            this.indexRange = indexRange;
            return this;
        }

        public Builder withIndexRangeExact(Boolean indexRangeExact) {
            this.indexRangeExact = indexRangeExact;
            return this;
        }

        public Builder withAvailabilityTimeOffset(Double availabilityTimeOffset) {
            this.availabilityTimeOffset = availabilityTimeOffset;
            return this;
        }

        public Builder withAvailabilityTimeComplete(Boolean availabilityTimeComplete) {
            this.availabilityTimeComplete = availabilityTimeComplete;
            return this;
        }

        public SegmentList build() {
            return new SegmentList(this.initialization, this.representationIndex, this.segmentTimeline, this.bitstreamswitchingElement, this.segmentURLs, this.duration, this.startNumber, this.href, this.actuate, this.timescale, this.presentationTimeOffset, this.indexRange, this.indexRangeExact, this.availabilityTimeOffset, this.availabilityTimeComplete);
        }
    }
}

