/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;

public class Segment {
    @XmlAttribute(name="t")
    private final Long t;
    @XmlAttribute(name="n")
    private final Long n;
    @XmlAttribute(name="d", required=true)
    private final long d;
    @XmlAttribute(name="r")
    private final Long r;

    private Segment(Long t, Long n, long d, Long r) {
        this.t = t;
        this.n = n;
        this.d = d;
        this.r = r;
    }

    private Segment() {
        this.t = null;
        this.n = null;
        this.d = 0L;
        this.r = null;
    }

    public Long getT() {
        return this.t;
    }

    public Long getN() {
        return this.n;
    }

    public long getD() {
        return this.d;
    }

    public Long getR() {
        return this.r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment s = (Segment)o;
        return this.d == s.d && Objects.equals(this.t, s.t) && Objects.equals(this.n, s.n) && Objects.equals(this.r, s.r);
    }

    public int hashCode() {
        return Objects.hash(this.t, this.n, this.d, this.r);
    }

    public String toString() {
        return "S{t=" + this.t + ", n=" + this.n + ", d=" + this.d + ", r=" + this.r + '}';
    }

    public Builder buildUpon() {
        return new Builder().withT(this.t).withN(this.n).withD(this.d).withR(this.r);
    }

    public static class Builder {
        private Long t;
        private Long n;
        private long d;
        private Long r;

        public Builder withT(Long t) {
            this.t = t;
            return this;
        }

        public Builder withN(Long n) {
            this.n = n;
            return this;
        }

        public Builder withD(long d) {
            this.d = d;
            return this;
        }

        public Builder withR(Long r) {
            this.r = r;
            return this;
        }

        public Segment build() {
            return new Segment(this.t, this.n, this.d, this.r);
        }
    }
}

