/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import java.time.Duration;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;

public class Range {
    @XmlAttribute(name="starttime")
    private final Duration starttime;
    @XmlAttribute(name="duration")
    private final Duration duration;

    private Range(Duration starttime, Duration duration) {
        this.starttime = starttime;
        this.duration = duration;
    }

    private Range() {
        this.starttime = null;
        this.duration = null;
    }

    public Duration getStarttime() {
        return this.starttime;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.starttime, range.starttime) && Objects.equals(this.duration, range.duration);
    }

    public int hashCode() {
        return Objects.hash(this.starttime, this.duration);
    }

    public String toString() {
        return "Range{starttime=" + this.starttime + ", duration=" + this.duration + '}';
    }

    public Builder buildUpon() {
        return new Builder().withStarttime(this.starttime).withDuration(this.duration);
    }

    public static class Builder {
        private Duration starttime;
        private Duration duration;

        public Builder withStarttime(Duration starttime) {
            this.starttime = starttime;
            return this;
        }

        public Builder withDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Range build() {
            return new Range(this.starttime, this.duration);
        }
    }
}

