/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import io.lindstrom.mpd.data.ActuateType;
import io.lindstrom.mpd.data.AdaptationSet;
import io.lindstrom.mpd.data.BaseURL;
import io.lindstrom.mpd.data.EventStream;
import io.lindstrom.mpd.data.SegmentBase;
import io.lindstrom.mpd.data.SegmentList;
import io.lindstrom.mpd.data.SegmentTemplate;
import io.lindstrom.mpd.data.Subset;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import io.lindstrom.mpd.support.Utils;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"id", "baseURLs", "segmentBase", "segmentList", "segmentTemplate", "assetIdentifier", "eventStreams", "adaptationSets", "subsets", "supplementalProperties"})
public class Period {
    @XmlElement(name="BaseURL", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<BaseURL> baseURLs;
    @XmlElement(name="SegmentBase", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentBase segmentBase;
    @XmlElement(name="SegmentList", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentList segmentList;
    @XmlElement(name="SegmentTemplate", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentTemplate segmentTemplate;
    @XmlElement(name="AssetIdentifier", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final Descriptor assetIdentifier;
    @XmlElement(name="EventStream", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<EventStream> eventStreams;
    @XmlElement(name="AdaptationSet", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<AdaptationSet> adaptationSets;
    @XmlElement(name="Subset", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Subset> subsets;
    @XmlElement(name="SupplementalProperty", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> supplementalProperties;
    @XmlAttribute(name="href", namespace="http://www.w3.org/1999/xlink")
    private final String href;
    @XmlAttribute(name="actuate", namespace="http://www.w3.org/1999/xlink")
    private final ActuateType actuate;
    @XmlAttribute(name="id")
    private final String id;
    @XmlAttribute(name="start")
    private final Duration start;
    @XmlAttribute(name="duration")
    private final Duration duration;
    @XmlAttribute(name="bitstreamSwitching")
    private final Boolean bitstreamSwitching;

    private Period(List<BaseURL> baseURLs, SegmentBase segmentBase, SegmentList segmentList, SegmentTemplate segmentTemplate, Descriptor assetIdentifier, List<EventStream> eventStreams, List<AdaptationSet> adaptationSets, List<Subset> subsets, List<Descriptor> supplementalProperties, String href, ActuateType actuate, String id, Duration start, Duration duration, Boolean bitstreamSwitching) {
        this.baseURLs = baseURLs;
        this.segmentBase = segmentBase;
        this.segmentList = segmentList;
        this.segmentTemplate = segmentTemplate;
        this.assetIdentifier = assetIdentifier;
        this.eventStreams = eventStreams;
        this.adaptationSets = adaptationSets;
        this.subsets = subsets;
        this.supplementalProperties = supplementalProperties;
        this.href = href;
        this.actuate = actuate;
        this.id = id;
        this.start = start;
        this.duration = duration;
        this.bitstreamSwitching = bitstreamSwitching;
    }

    private Period() {
        this.baseURLs = null;
        this.segmentBase = null;
        this.segmentList = null;
        this.segmentTemplate = null;
        this.assetIdentifier = null;
        this.eventStreams = null;
        this.adaptationSets = null;
        this.subsets = null;
        this.supplementalProperties = null;
        this.href = null;
        this.actuate = null;
        this.id = null;
        this.start = null;
        this.duration = null;
        this.bitstreamSwitching = null;
    }

    public List<BaseURL> getBaseURLs() {
        return Utils.unmodifiableList(this.baseURLs);
    }

    public SegmentBase getSegmentBase() {
        return this.segmentBase;
    }

    public SegmentList getSegmentList() {
        return this.segmentList;
    }

    public SegmentTemplate getSegmentTemplate() {
        return this.segmentTemplate;
    }

    public Descriptor getAssetIdentifier() {
        return this.assetIdentifier;
    }

    public List<EventStream> getEventStreams() {
        return Utils.unmodifiableList(this.eventStreams);
    }

    public List<AdaptationSet> getAdaptationSets() {
        return Utils.unmodifiableList(this.adaptationSets);
    }

    public List<Subset> getSubsets() {
        return Utils.unmodifiableList(this.subsets);
    }

    public List<Descriptor> getSupplementalProperties() {
        return Utils.unmodifiableList(this.supplementalProperties);
    }

    public String getHref() {
        return this.href;
    }

    public ActuateType getActuate() {
        return this.actuate;
    }

    public String getId() {
        return this.id;
    }

    public Duration getStart() {
        return this.start;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Boolean getBitstreamSwitching() {
        return this.bitstreamSwitching;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Period period = (Period)o;
        return Objects.equals(this.baseURLs, period.baseURLs) && Objects.equals(this.segmentBase, period.segmentBase) && Objects.equals(this.segmentList, period.segmentList) && Objects.equals(this.segmentTemplate, period.segmentTemplate) && Objects.equals(this.assetIdentifier, period.assetIdentifier) && Objects.equals(this.eventStreams, period.eventStreams) && Objects.equals(this.adaptationSets, period.adaptationSets) && Objects.equals(this.subsets, period.subsets) && Objects.equals(this.supplementalProperties, period.supplementalProperties) && Objects.equals(this.href, period.href) && this.actuate == period.actuate && Objects.equals(this.id, period.id) && Objects.equals(this.start, period.start) && Objects.equals(this.duration, period.duration) && Objects.equals(this.bitstreamSwitching, period.bitstreamSwitching);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseURLs, this.segmentBase, this.segmentList, this.segmentTemplate, this.assetIdentifier, this.eventStreams, this.adaptationSets, this.subsets, this.supplementalProperties, this.href, this.actuate, this.id, this.start, this.duration, this.bitstreamSwitching});
    }

    public String toString() {
        return "Period{baseURLs=" + this.baseURLs + ", segmentBase=" + this.segmentBase + ", segmentList=" + this.segmentList + ", segmentTemplate=" + this.segmentTemplate + ", assetIdentifier=" + this.assetIdentifier + ", eventStreams=" + this.eventStreams + ", adaptationSets=" + this.adaptationSets + ", subsets=" + this.subsets + ", supplementalProperties=" + this.supplementalProperties + ", href='" + this.href + '\'' + ", actuate=" + (Object)((Object)this.actuate) + ", id='" + this.id + '\'' + ", start=" + this.start + ", duration=" + this.duration + ", bitstreamSwitching=" + this.bitstreamSwitching + '}';
    }

    public Builder buildUpon() {
        return new Builder().withBaseURLs(this.baseURLs).withSegmentBase(this.segmentBase).withSegmentList(this.segmentList).withSegmentTemplate(this.segmentTemplate).withAssetIdentifier(this.assetIdentifier).withEventStreams(this.eventStreams).withAdaptationSets(this.adaptationSets).withSubsets(this.subsets).withSupplementalProperties(this.supplementalProperties).withHref(this.href).withActuate(this.actuate).withId(this.id).withStart(this.start).withDuration(this.duration).withBitstreamSwitching(this.bitstreamSwitching);
    }

    public static class Builder {
        private List<BaseURL> baseURLs;
        private SegmentBase segmentBase;
        private SegmentList segmentList;
        private SegmentTemplate segmentTemplate;
        private Descriptor assetIdentifier;
        private List<EventStream> eventStreams;
        private List<AdaptationSet> adaptationSets;
        private List<Subset> subsets;
        private List<Descriptor> supplementalProperties;
        private String href;
        private ActuateType actuate;
        private String id;
        private Duration start;
        private Duration duration;
        private Boolean bitstreamSwitching;

        public Builder withBaseURLs(List<BaseURL> baseURLs) {
            this.baseURLs = baseURLs;
            return this;
        }

        public Builder withSegmentBase(SegmentBase segmentBase) {
            this.segmentBase = segmentBase;
            return this;
        }

        public Builder withSegmentList(SegmentList segmentList) {
            this.segmentList = segmentList;
            return this;
        }

        public Builder withSegmentTemplate(SegmentTemplate segmentTemplate) {
            this.segmentTemplate = segmentTemplate;
            return this;
        }

        public Builder withAssetIdentifier(Descriptor assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
            return this;
        }

        public Builder withEventStreams(List<EventStream> eventStreams) {
            this.eventStreams = eventStreams;
            return this;
        }

        public Builder withAdaptationSets(List<AdaptationSet> adaptationSets) {
            this.adaptationSets = adaptationSets;
            return this;
        }

        public Builder withAdaptationSet(AdaptationSet adaptationSet, AdaptationSet ... moreAdaptationSets) {
            this.adaptationSets = Utils.varargsToList(adaptationSet, moreAdaptationSets);
            return this;
        }

        public Builder withSubsets(List<Subset> subsets) {
            this.subsets = subsets;
            return this;
        }

        public Builder withSupplementalProperties(List<Descriptor> supplementalProperties) {
            this.supplementalProperties = supplementalProperties;
            return this;
        }

        public Builder withHref(String href) {
            this.href = href;
            return this;
        }

        public Builder withActuate(ActuateType actuate) {
            this.actuate = actuate;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withStart(Duration start) {
            this.start = start;
            return this;
        }

        public Builder withDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder withBitstreamSwitching(Boolean bitstreamSwitching) {
            this.bitstreamSwitching = bitstreamSwitching;
            return this;
        }

        public Period build() {
            return new Period(this.baseURLs, this.segmentBase, this.segmentList, this.segmentTemplate, this.assetIdentifier, this.eventStreams, this.adaptationSets, this.subsets, this.supplementalProperties, this.href, this.actuate, this.id, this.start, this.duration, this.bitstreamSwitching);
        }
    }
}

